/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import nl.jpoint.vertx.mod.deploy.request.DeployApplicationRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployArtifactRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployConfigRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployState;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeployRequest {
    private final UUID id = UUID.randomUUID();
    private final List<DeployApplicationRequest> modules;
    private final List<DeployConfigRequest> configs;
    private final List<DeployArtifactRequest> artifacts;
    private final boolean elb;
    private final boolean autoScaling;
    private boolean decrementDesiredCapacity = true;
    private final String autoScalingGroup;
    private final String instanceId;
    private boolean restart;
    private DeployState state;

    @JsonCreator
    public DeployRequest(@JsonProperty(value="modules") List<DeployApplicationRequest> modules, @JsonProperty(value="artifacts") List<DeployArtifactRequest> artifacts, @JsonProperty(value="configs") List<DeployConfigRequest> configs, @JsonProperty(value="with_elb") boolean elb, @JsonProperty(value="with_as") boolean autoScaling, @JsonProperty(value="as_group_id") String autoScalingGroup, @JsonProperty(value="instance_id") String instanceId, @JsonProperty(value="restart") boolean restart) {
        this.modules = modules != null ? modules : Collections.emptyList();
        this.artifacts = artifacts != null ? artifacts : Collections.emptyList();
        this.configs = configs != null ? configs : Collections.emptyList();
        this.elb = elb;
        this.autoScaling = autoScaling;
        this.autoScalingGroup = autoScalingGroup;
        this.instanceId = instanceId;
        this.restart = restart;
    }

    public List<DeployArtifactRequest> getArtifacts() {
        return this.artifacts;
    }

    public List<DeployApplicationRequest> getModules() {
        return this.modules;
    }

    public List<DeployConfigRequest> getConfigs() {
        return this.configs;
    }

    public UUID getId() {
        return this.id;
    }

    public String getAutoScalingGroup() {
        return this.autoScalingGroup;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public boolean withElb() {
        return this.elb;
    }

    public boolean withAutoScaling() {
        return this.elb && this.autoScaling;
    }

    public boolean withRestart() {
        return this.restart;
    }

    public void setState(DeployState state) {
        this.state = state;
    }

    public DeployState getState() {
        return this.state;
    }

    public boolean isDecrementDesiredCapacity() {
        return this.decrementDesiredCapacity;
    }

    @JsonProperty(value="as_decrement_desired_capacity")
    public void setDecrementDesiredCapacity(boolean decrementDesiredCapacity) {
        this.decrementDesiredCapacity = decrementDesiredCapacity;
    }

    public void setRestart(boolean restart) {
        this.restart = restart;
    }
}

