/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.util.Base64;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import nl.jpoint.vertx.mod.deploy.util.MetadataXPathUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveSnapshotVersion
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ResolveSnapshotVersion.class);
    private final DeployConfig config;
    private final String logId;

    public ResolveSnapshotVersion(DeployConfig config, String logId) {
        this.config = config;
        this.logId = logId;
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        String realSnapshotVersion;
        DefaultHttpClient httpclient = new DefaultHttpClient();
        boolean resolved = false;
        String string = realSnapshotVersion = request.isSnapshot() ? request.getVersion() : null;
        if (request.isSnapshot()) {
            LOG.info("[{} - {}]: Artifact is -SNAPSHOT, trying to parse metadata for last version {}.", new Object[]{this.logId, request.getId(), request.getModuleId()});
            realSnapshotVersion = this.retrieveAndParseMetadata(request, (HttpClient)httpclient, this.config.getNexusUrl());
            if (realSnapshotVersion != null) {
                LOG.info("[{} - {}]: Parsed metadata. Snapshot version is {} ", new Object[]{this.logId, request.getId(), realSnapshotVersion});
            }
        }
        return new JsonObject().put("success", Boolean.valueOf(resolved)).put("version", realSnapshotVersion);
    }

    private String retrieveAndParseMetadata(ModuleRequest request, HttpClient httpclient, URI repoUri) {
        HttpGet getMetadata = new HttpGet(repoUri.resolve(repoUri.getPath() + "/" + request.getMetadataLocation()));
        if (this.config.isHttpAuthentication()) {
            this.setAuthorizationHeader(getMetadata);
        }
        try {
            HttpResponse response = httpclient.execute((HttpUriRequest)getMetadata);
            if (response.getStatusLine().getStatusCode() != HttpResponseStatus.OK.code()) {
                LOG.error("[{} - {}]: No metadata found for module {} with error code {} with request {}", new Object[]{this.logId, request.getId(), request.getModuleId(), response.getStatusLine().getStatusCode(), getMetadata.getURI()});
                return null;
            }
            byte[] metadata = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            return MetadataXPathUtil.getRealSnapshotVersionFromMetadata(metadata, request);
        }
        catch (IOException e) {
            LOG.error("[{} - {}]: Error while downloading metadata for module {} : {}", new Object[]{this.logId, request.getId(), request.getModuleId(), e.getMessage()});
            return null;
        }
    }

    private void setAuthorizationHeader(HttpGet httpClientRequest) {
        String usernameAndPassword = this.config.getHttpAuthUser() + ":" + this.config.getHttpAuthPassword();
        String authorizationHeaderName = "Authorization";
        String authorizationHeaderValue = "Basic " + Base64.getEncoder().encodeToString(usernameAndPassword.getBytes());
        httpClientRequest.addHeader(authorizationHeaderName, authorizationHeaderValue);
    }
}

