/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.request;

import java.util.UUID;

public abstract class ModuleRequest {
    private final UUID id = UUID.randomUUID();
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String type;
    private String snapshotVersion = null;

    ModuleRequest(String groupId, String artifactId, String version, String classifier, String type) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.type = type != null ? type : "jar";
    }

    ModuleRequest(String groupId, String artifactId, String version, String type) {
        this(groupId, artifactId, version, null, type);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public UUID getId() {
        return this.id;
    }

    public String getModuleId() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String getMavenArtifactId() {
        return this.groupId + ":" + this.artifactId;
    }

    public String getRemoteLocation() {
        StringBuilder builder = new StringBuilder().append(this.getGroupId().replaceAll("\\.", "/")).append("/").append(this.getArtifactId()).append("/").append(this.getVersion()).append("/").append(this.getFileName());
        return builder.toString();
    }

    public String getFileName() {
        StringBuilder builder = new StringBuilder().append(this.getArtifactId()).append("-");
        if (this.snapshotVersion != null) {
            builder.append(this.getSnapshotVersion());
        } else {
            builder.append(this.getVersion());
        }
        if (this.classifier != null && !this.classifier.isEmpty()) {
            builder.append("-").append(this.classifier);
        }
        builder.append(".");
        builder.append(this.type);
        return builder.toString();
    }

    public String getSnapshotVersion() {
        return this.snapshotVersion;
    }

    public void setSnapshotVersion(String snapshotVersion) {
        this.snapshotVersion = snapshotVersion;
    }

    public boolean isSnapshot() {
        return this.version.endsWith("-SNAPSHOT");
    }

    public String getMetadataLocation() {
        return this.getGroupId().replaceAll("\\.", "/") + "/" + this.getArtifactId() + "/" + this.getVersion() + "/" + "maven-metadata.xml";
    }

    public String getType() {
        return this.type;
    }

    public abstract boolean restart();
}

