/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.web.Router;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.handler.RestDeployArtifactHandler;
import nl.jpoint.vertx.mod.deploy.handler.RestDeployAwsHandler;
import nl.jpoint.vertx.mod.deploy.handler.RestDeployHandler;
import nl.jpoint.vertx.mod.deploy.handler.RestDeployModuleHandler;
import nl.jpoint.vertx.mod.deploy.handler.servicebus.DeployHandler;
import nl.jpoint.vertx.mod.deploy.service.AwsService;
import nl.jpoint.vertx.mod.deploy.service.DeployApplicationService;
import nl.jpoint.vertx.mod.deploy.service.DeployArtifactService;
import nl.jpoint.vertx.mod.deploy.service.DeployConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AwsDeployApplication
extends AbstractVerticle {
    private static final Logger LOG = LoggerFactory.getLogger(AwsDeployApplication.class);
    private boolean initiated = false;

    public void start() {
        MDC.put((String)"service", (String)"deploy");
        DeployConfig deployconfig = DeployConfig.fromJsonObject(this.config());
        if (this.config() == null) {
            LOG.error("Unable to read config file");
            throw new IllegalStateException("Unable to read config file");
        }
        DeployApplicationService deployApplicationService = new DeployApplicationService(deployconfig, this.getVertx().fileSystem());
        DeployArtifactService deployArtifactService = new DeployArtifactService(this.getVertx(), deployconfig);
        DeployConfigService deployConfigService = new DeployConfigService(this.getVertx(), deployconfig);
        AwsService awsService = null;
        if (deployconfig.isAwsEnabled()) {
            awsService = new AwsService(this.getVertx(), deployconfig);
        }
        Router router = Router.router((Vertx)this.getVertx());
        router.post("/deploy/deploy").handler((Handler)new RestDeployHandler(deployApplicationService, deployArtifactService, deployConfigService, awsService, deployconfig.getAuthToken()));
        router.post("/deploy/module*").handler((Handler)new RestDeployModuleHandler(deployApplicationService));
        router.post("/deploy/artifact*").handler((Handler)new RestDeployArtifactHandler(deployArtifactService));
        if (deployconfig.isAwsEnabled()) {
            this.vertx.eventBus().consumer("aws.service.deploy", (Handler)new DeployHandler(awsService, deployApplicationService, deployArtifactService, deployConfigService));
            router.get("/deploy/status/:id").blockingHandler((Handler)new RestDeployAwsHandler(awsService));
        }
        router.get("/status").handler(event -> {
            if (this.initiated) {
                event.response().setStatusCode(HttpResponseStatus.FORBIDDEN.code());
            } else {
                event.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            }
            event.response().end();
            event.response().close();
        });
        HttpServer server = this.vertx.createHttpServer().requestHandler(arg_0 -> ((Router)router).accept(arg_0));
        server.listen(this.config().getInteger("http.port", Integer.valueOf(6789)).intValue());
        this.initiated = true;
        LOG.info("{}: Instantiated module.", (Object)"ClusterManager");
    }

    public void stop() throws Exception {
        LOG.warn("Stopping deploy application");
    }
}

