/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;

public class AwsContext {
    private final AWSCredentials credentials;
    private final Region awsRegion;

    private AwsContext(String accesKey, String secretAccessKey, String region) {
        this.credentials = new BasicAWSCredentials(accesKey, secretAccessKey);
        this.awsRegion = Region.getRegion((Regions)Regions.fromName((String)region));
    }

    public static AwsContext build(String accessKey, String secretAccessKey, String region) {
        if (accessKey != null && !accessKey.isEmpty() && (secretAccessKey == null || secretAccessKey.isEmpty())) {
            throw new IllegalStateException("Missing aws key config");
        }
        return new AwsContext(accessKey, secretAccessKey, region);
    }

    public Region getAwsRegion() {
        return this.awsRegion;
    }

    public AWSCredentials getCredentials() {
        return this.credentials;
    }
}

