/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import nl.jpoint.vertx.mod.deploy.util.FileDigestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractArtifact
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractArtifact.class);
    private final Vertx vertx;
    private final DeployConfig config;
    private final Path basePath;
    private final boolean deleteBase;
    private final boolean checkConfig;
    private final String logConstant;
    private final FileDigestUtil fileDigestUtil;
    private boolean configChanged = false;

    public ExtractArtifact(Vertx vertx, DeployConfig config, Path basePath, boolean deleteBase, boolean checkConfig, String logConstant) {
        this.vertx = vertx;
        this.config = config;
        this.basePath = basePath;
        this.deleteBase = deleteBase;
        this.checkConfig = checkConfig;
        this.logConstant = logConstant;
        this.fileDigestUtil = new FileDigestUtil();
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        try (FileSystem zipFs = this.getFileSystem(this.config.getArtifactRepo() + "/" + request.getFileName());){
            LOG.info("[{} - {}]: Extracting artifact {} to {}.", new Object[]{this.logConstant, request.getId(), request.getModuleId(), this.basePath});
            if (this.deleteBase) {
                this.removeBasePath(request, this.basePath);
            }
            Path zipRoot = zipFs.getPath("/", new String[0]);
            Files.walkFileTree(zipRoot, this.CopyingFileVisitor(this.basePath, request));
            LOG.info("[{} - {}]: Extracted artifact {} to {}.", new Object[]{"Deploy SiteRequest", request.getId(), request.getModuleId(), this.basePath});
        }
        catch (IOException | InvalidPathException e) {
            LOG.error("[{} - {}]: Error while extracting artifact {} -> {}.", new Object[]{this.logConstant, request.getId(), request.getModuleId(), e.getMessage()});
            return new JsonObject().put("success", Boolean.valueOf(false));
        }
        return new JsonObject().put("success", Boolean.valueOf(true)).put("configChanged", Boolean.valueOf(this.checkConfig && this.configChanged));
    }

    private SimpleFileVisitor<Path> CopyingFileVisitor(final Path basePath, final ModuleRequest request) {
        return new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                byte[] oldDigest = null;
                byte[] newDigest = null;
                if ("artifact_context.xml".equals(file.getFileName().toString())) {
                    return FileVisitResult.CONTINUE;
                }
                Path unpackFile = Paths.get(basePath.toString(), file.toString());
                if (ExtractArtifact.this.checkConfig) {
                    oldDigest = ExtractArtifact.this.fileDigestUtil.getFileMd5Sum(unpackFile);
                }
                Files.copy(file, unpackFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                if (ExtractArtifact.this.checkConfig) {
                    newDigest = ExtractArtifact.this.fileDigestUtil.getFileMd5Sum(unpackFile);
                }
                if (ExtractArtifact.this.checkConfig && !ExtractArtifact.this.configChanged && !Arrays.equals(oldDigest, newDigest)) {
                    LOG.warn("[{} - {}]: Config changed, forcing container restart if necessary.", new Object[]{ExtractArtifact.this.logConstant, request.getId(), request.getModuleId()});
                    ExtractArtifact.this.configChanged = true;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path subDir = Paths.get(basePath.toString(), dir.toString());
                if (Files.notExists(subDir, new LinkOption[0])) {
                    Files.createDirectory(subDir, new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }
        };
    }

    private void removeBasePath(ModuleRequest request, Path basePath) {
        if (!basePath.getParent().toFile().exists() || !basePath.getParent().toFile().canWrite()) {
            LOG.warn("[{} - {}]: Unable to extract artifact {} -> {} not exist or not writable.", new Object[]{this.logConstant, request.getId(), request.getModuleId(), basePath.getParent().toString()});
            LOG.warn("[{} - {}]: Unable to extract artifact {} to basePath -> {}.", new Object[]{this.logConstant, request.getId(), request.getModuleId(), basePath.getParent().toFile().toString()});
        }
        if (basePath.toFile().exists()) {
            LOG.info("[{} - {}]: Removing base path -> {}.", new Object[]{this.logConstant, request.getId(), basePath.toAbsolutePath()});
            this.vertx.fileSystem().deleteRecursiveBlocking(basePath.toString(), true);
        }
    }

    private FileSystem getFileSystem(String location) throws IOException {
        Path path = Paths.get(location, new String[0]);
        URI uri = URI.create("jar:file:" + path.toUri().getPath());
        return FileSystems.newFileSystem(uri, new HashMap());
    }
}

