/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import io.vertx.core.json.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import nl.jpoint.vertx.mod.deploy.util.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopApplication
implements Command<ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(StopApplication.class);
    final JsonObject result = new JsonObject();
    private DeployConfig config;
    private ProcessUtils processUtils;

    public StopApplication(DeployConfig config) {
        this.config = config;
        this.processUtils = new ProcessUtils(config);
    }

    @Override
    public JsonObject execute(ModuleRequest request) {
        this.result.put("module_stopped", Boolean.valueOf(false));
        this.stopWithInit(request);
        LOG.info("[{} - {}]: Waiting for module {} to stop.", new Object[]{"DeployRequest", request.getId(), request.getMavenArtifactId()});
        CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> {
            while (this.processUtils.checkModuleRunning(request.getMavenArtifactId())) {
            }
            return "42";
        });
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.info("[{} - {}]: Error while Waiting for  module '{}' with applicationId '{}' to stop -> '{}'.", new Object[]{"DeployRequest", request.getId(), request.getModuleId(), e});
        }
        LOG.info("[{} - {}]: Module '{}' stopped.", new Object[]{"DeployRequest", request.getId(), request.getMavenArtifactId()});
        return this.result;
    }

    public void stopWithInit(ModuleRequest request) {
        LOG.info("[{} - {}]: Stopping module '{}' with applicationId '{}'.", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
        try {
            String outputLine;
            Process killProcess = Runtime.getRuntime().exec(new String[]{this.config.getVertxHome().resolve("bin/vertx").toString(), "stop", request.getMavenArtifactId()});
            killProcess.waitFor(1L, TimeUnit.MINUTES);
            int exitValue = killProcess.exitValue();
            BufferedReader output = new BufferedReader(new InputStreamReader(killProcess.getInputStream()));
            while ((outputLine = output.readLine()) != null && !outputLine.isEmpty()) {
                LOG.info("[{} - {}]: {}", new Object[]{"DeployRequest", request.getId(), outputLine});
            }
            if (exitValue != 0) {
                String errorLine;
                BufferedReader errorOut = new BufferedReader(new InputStreamReader(killProcess.getErrorStream()));
                while ((errorLine = errorOut.readLine()) != null) {
                    LOG.error("[{} - {}]: {}", new Object[]{"DeployRequest", request.getId(), errorLine});
                }
            }
            this.result.put("module_stopped", Boolean.valueOf(true));
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{} - {}]: Failed to stop module {}", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
        }
    }
}

