/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.handler.servicebus;

import io.vertx.core.Handler;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import nl.jpoint.vertx.mod.deploy.aws.AwsState;
import nl.jpoint.vertx.mod.deploy.request.DeployApplicationRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployArtifactRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployConfigRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployState;
import nl.jpoint.vertx.mod.deploy.service.AwsService;
import nl.jpoint.vertx.mod.deploy.service.DeployApplicationService;
import nl.jpoint.vertx.mod.deploy.service.DeployArtifactService;
import nl.jpoint.vertx.mod.deploy.service.DeployConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployHandler
implements Handler<Message<JsonObject>> {
    private static final Logger LOG = LoggerFactory.getLogger(DeployHandler.class);
    private final AwsService awsService;
    private final DeployApplicationService deployApplicationService;
    private final DeployArtifactService deployArtifactService;
    private final DeployConfigService deployConfigService;

    public DeployHandler(AwsService awsService, DeployApplicationService deployApplicationService, DeployArtifactService deployArtifactService, DeployConfigService deployConfigService) {
        this.awsService = awsService;
        this.deployApplicationService = deployApplicationService;
        this.deployArtifactService = deployArtifactService;
        this.deployConfigService = deployConfigService;
    }

    public void handle(Message<JsonObject> message) {
        JsonObject body = (JsonObject)message.body();
        String deployId = body.getString("id");
        AwsState state = AwsState.valueOf(body.getString("state"));
        if (!body.getBoolean("success").booleanValue()) {
            this.awsService.failBuild(deployId);
            return;
        }
        LOG.info("[{} - {}]: Handle deploy request with state {}", new Object[]{"DeployRequest", deployId, state});
        switch (state) {
            case STANDBY: 
            case NOTREGISTERED: 
            case OUTOFSERVICE: {
                this.deployArtifacts(deployId);
                break;
            }
            case INSERVICE: {
                this.registerInstance(deployId);
                break;
            }
        }
    }

    private void registerInstance(String deployId) {
        this.awsService.updateAndGetRequest(DeployState.SUCCESS, deployId);
    }

    private void deployArtifacts(String deployId) {
        DeployRequest deployRequest = this.awsService.updateAndGetRequest(DeployState.DEPLOYING_CONFIGS, deployId);
        JsonObject deployOk = null;
        if (deployRequest.getConfigs() != null && !deployRequest.getConfigs().isEmpty()) {
            for (DeployConfigRequest configRequests : deployRequest.getConfigs()) {
                deployOk = this.deployConfigService.deploy(configRequests);
                if (!deployOk.getBoolean("result").booleanValue()) {
                    this.awsService.failBuild(deployId);
                    return;
                }
                if (deployRequest.withRestart() || !deployOk.getBoolean("configChanged", Boolean.valueOf(false)).booleanValue()) continue;
                this.awsService.updateRestartAndGetRequest(true, deployId);
                deployRequest.setRestart(true);
            }
        }
        if (deployRequest.withRestart()) {
            this.deployApplicationService.stopContainer();
        }
        if ((deployRequest = this.awsService.updateAndGetRequest(DeployState.DEPLOYING_ARTIFACTS, deployId)).getArtifacts() != null && !deployRequest.getArtifacts().isEmpty()) {
            for (DeployArtifactRequest artifactRequest : deployRequest.getArtifacts()) {
                deployOk = this.deployArtifactService.deploy(artifactRequest);
                if (deployOk.getBoolean("result").booleanValue()) continue;
                this.awsService.failBuild(deployId);
                return;
            }
        }
        if ((deployRequest = this.awsService.updateAndGetRequest(DeployState.DEPLOYING_MODULES, deployId)).getModules() != null && !deployRequest.getModules().isEmpty()) {
            for (DeployApplicationRequest moduleRequest : deployRequest.getModules()) {
                deployOk = this.deployApplicationService.deploy(moduleRequest);
                if (deployOk.getBoolean("result").booleanValue()) continue;
                this.awsService.failBuild(deployId);
                return;
            }
        }
        this.awsService.updateAndGetRequest(DeployState.WAITING_FOR_REGISTER, deployId);
        this.awsService.registerInstance(deployId);
    }
}

