/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.service;

import io.vertx.core.file.FileSystem;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.ResolveSnapshotVersion;
import nl.jpoint.vertx.mod.deploy.command.RunApplication;
import nl.jpoint.vertx.mod.deploy.command.StopApplication;
import nl.jpoint.vertx.mod.deploy.request.DeployApplicationRequest;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import nl.jpoint.vertx.mod.deploy.service.DeployService;
import nl.jpoint.vertx.mod.deploy.util.ApplicationVersion;
import nl.jpoint.vertx.mod.deploy.util.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployApplicationService
implements DeployService<DeployApplicationRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(DeployApplicationService.class);
    private final DeployConfig config;
    private final Map<String, JsonObject> installedModules;
    private FileSystem fs;

    public DeployApplicationService(DeployConfig config, FileSystem fs) {
        this.config = config;
        this.fs = fs;
        this.installedModules = new ProcessUtils(config).listInstalledAndRunningModules();
    }

    @Override
    public JsonObject deploy(DeployApplicationRequest deployRequest) {
        JsonObject runResult;
        RunApplication runModCommand;
        ApplicationVersion moduleInstalled;
        ResolveSnapshotVersion resolveVersion;
        JsonObject result;
        if (deployRequest.isSnapshot() && !this.config.isMavenLocal() && (result = (resolveVersion = new ResolveSnapshotVersion(this.config, "DeployRequest")).execute(deployRequest)).getBoolean("success").booleanValue()) {
            deployRequest.setSnapshotVersion(result.getString("version"));
        }
        if ((moduleInstalled = this.moduleInstalled(deployRequest)).equals((Object)ApplicationVersion.ERROR)) {
            return new JsonObject().put("result", Boolean.valueOf(false));
        }
        if (moduleInstalled.equals((Object)ApplicationVersion.INSTALLED)) {
            if (deployRequest.restart()) {
                runModCommand = new RunApplication(this.fs, this.config);
                runModCommand.execute(deployRequest);
            }
            return new JsonObject().put("result", Boolean.valueOf(true));
        }
        if (!moduleInstalled.equals((Object)ApplicationVersion.INSTALLED) && moduleInstalled.equals((Object)ApplicationVersion.OLDER_VERSION)) {
            StopApplication stopApplicationCommand;
            JsonObject result2;
            if (!deployRequest.restart() && !(result2 = (stopApplicationCommand = new StopApplication(this.config)).execute(deployRequest)).getBoolean("module_stopped").booleanValue()) {
                return new JsonObject().put("result", Boolean.valueOf(false));
            }
            this.installedModules.remove(deployRequest.getMavenArtifactId());
        }
        if (!(runResult = (runModCommand = new RunApplication(this.fs, this.config)).execute(deployRequest)).getBoolean("success").booleanValue()) {
            return new JsonObject().put("result", Boolean.valueOf(false));
        }
        this.installedModules.put(deployRequest.getMavenArtifactId(), runResult);
        return new JsonObject().put("result", Boolean.valueOf(true));
    }

    private ApplicationVersion moduleInstalled(ModuleRequest deployRequest) {
        if (!this.installedModules.containsKey(deployRequest.getMavenArtifactId())) {
            LOG.info("[{} - {}]: Module ({}) not installed.", new Object[]{"DeployRequest", deployRequest.getId(), deployRequest.getModuleId()});
            return ApplicationVersion.NOT_INSTALLED;
        }
        JsonObject installedModule = this.installedModules.get(deployRequest.getMavenArtifactId());
        String requestedVersion = deployRequest.getSnapshotVersion() != null ? deployRequest.getSnapshotVersion() : deployRequest.getVersion();
        boolean sameVersion = installedModule.getString("maven_version").equals(requestedVersion);
        if (sameVersion) {
            if (!this.checkModuleRunning(deployRequest)) {
                LOG.info("[{} - {}]: Module ({}) stopped externally.", new Object[]{"DeployRequest", deployRequest.getId(), deployRequest.getModuleId()});
                return ApplicationVersion.NOT_INSTALLED;
            }
            LOG.info("[{} - {}]: Module ({}) already installed.", new Object[]{"DeployRequest", deployRequest.getId(), deployRequest.getModuleId()});
        }
        return sameVersion ? ApplicationVersion.INSTALLED : ApplicationVersion.OLDER_VERSION;
    }

    private boolean checkModuleRunning(ModuleRequest deployRequest) {
        return new ProcessUtils(this.config).checkModuleRunning(deployRequest.getMavenArtifactId());
    }

    public void stopContainer() {
        this.installedModules.entrySet().stream().map(Map.Entry::getValue).forEach(module -> {
            StopApplication stopApplication = new StopApplication(this.config);
            String[] mavenIds = module.getString("maven_id").split(":", 2);
            stopApplication.execute(new DeployApplicationRequest(mavenIds[0], mavenIds[1], module.getString("maven_version"), true, "jar"));
        });
    }
}

