/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.service;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.DownloadArtifact;
import nl.jpoint.vertx.mod.deploy.command.ExtractArtifact;
import nl.jpoint.vertx.mod.deploy.command.ResolveSnapshotVersion;
import nl.jpoint.vertx.mod.deploy.request.DeployArtifactRequest;
import nl.jpoint.vertx.mod.deploy.service.DeployService;
import nl.jpoint.vertx.mod.deploy.util.ArtifactContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployArtifactService
implements DeployService<DeployArtifactRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(DeployArtifactService.class);
    private final Vertx vertx;
    private final DeployConfig config;
    private final Map<String, String> installedArtifacts;

    public DeployArtifactService(Vertx vertx, DeployConfig config) {
        this.vertx = vertx;
        this.config = config;
        this.installedArtifacts = new HashMap<String, String>();
    }

    @Override
    public JsonObject deploy(DeployArtifactRequest deployRequest) {
        DownloadArtifact downloadArtifactCommand;
        JsonObject downloadResult;
        ResolveSnapshotVersion resolveVersion;
        JsonObject result;
        if (deployRequest.isSnapshot() && (result = (resolveVersion = new ResolveSnapshotVersion(this.config, "Deploy SiteRequest")).execute(deployRequest)).getBoolean("success").booleanValue()) {
            deployRequest.setSnapshotVersion(result.getString("version"));
        }
        if (this.installedArtifacts.containsKey(deployRequest.getGroupId() + ":" + deployRequest.getArtifactId()) && this.installedArtifacts.get(deployRequest.getGroupId() + ":" + deployRequest.getArtifactId()).equals(deployRequest.getSnapshotVersion())) {
            LOG.info("[{} - {}]: Same SNAPSHOT version ({}) of Artifact {} already installed.", new Object[]{"Deploy SiteRequest", deployRequest.getId(), deployRequest.getSnapshotVersion(), deployRequest.getModuleId()});
            new JsonObject().put("result", Boolean.valueOf(true));
        }
        if (!(downloadResult = (downloadArtifactCommand = new DownloadArtifact(this.config)).execute(deployRequest)).getBoolean("success").booleanValue()) {
            new JsonObject().put("result", Boolean.valueOf(false));
        }
        ArtifactContextUtil artifactContextUtil = new ArtifactContextUtil(this.config.getArtifactRepo().resolve(deployRequest.getFileName()));
        ExtractArtifact extractSite = new ExtractArtifact(this.vertx, this.config, Paths.get(artifactContextUtil.getBaseLocation(), new String[0]), true, false, "Deploy SiteRequest");
        JsonObject extractResult = extractSite.execute(deployRequest);
        if (deployRequest.getSnapshotVersion() != null) {
            this.installedArtifacts.put(deployRequest.getGroupId() + ":" + deployRequest.getArtifactId(), deployRequest.getSnapshotVersion());
        }
        return new JsonObject().put("result", extractResult.getBoolean("success"));
    }
}

