/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import io.vertx.core.Vertx;
import io.vertx.rxjava.core.buffer.Buffer;
import java.net.URI;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import nl.jpoint.vertx.mod.deploy.util.MetadataXPathUtil;
import nl.jpoint.vertx.mod.deploy.util.RxHttpUtil;
import rx.Observable;

public class ResolveSnapshotVersion<T extends ModuleRequest>
implements Command<T> {
    private final DeployConfig config;
    private io.vertx.rxjava.core.Vertx rxVertx;

    public ResolveSnapshotVersion(DeployConfig config, Vertx vertx) {
        this.rxVertx = new io.vertx.rxjava.core.Vertx(vertx);
        this.config = config;
    }

    @Override
    public Observable<T> executeAsync(T request) {
        URI location = this.config.getNexusUrl().resolve(this.config.getNexusUrl().getPath() + "/" + ((ModuleRequest)request).getMetadataLocation());
        String filename = this.createTempFile(((ModuleRequest)request).getArtifactId());
        return new RxHttpUtil(this.rxVertx, this.config).get(location, filename).flatMap(x -> {
            request.setSnapshotVersion(this.retrieveAndParseMetadata(filename, (ModuleRequest)request));
            return Observable.just((Object)request);
        }).flatMap(x -> this.rxVertx.fileSystem().deleteObservable(filename)).flatMap(x -> Observable.just((Object)request));
    }

    private String createTempFile(String filename) {
        return System.getProperty("java.io.tmpdir") + "/" + filename;
    }

    private String retrieveAndParseMetadata(String fileLocation, ModuleRequest request) {
        Buffer b = this.rxVertx.fileSystem().readFileBlocking(fileLocation);
        return MetadataXPathUtil.getRealSnapshotVersionFromMetadata(b.toString().getBytes(), request);
    }
}

