/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.DeployConfigRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class RunConsoleCommand
implements Command<DeployConfigRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(RunConsoleCommand.class);
    private final String command;

    public RunConsoleCommand(String command) {
        this.command = command;
    }

    @Override
    public Observable<DeployConfigRequest> executeAsync(DeployConfigRequest deployConfigRequest) {
        if (this.command == null || this.command.isEmpty()) {
            LOG.error("[{} - {}]: Failed to run empty command.", (Object)"ConsoleCommand", (Object)deployConfigRequest.getId());
            throw new IllegalStateException();
        }
        LOG.info("[{} - {}]: Running console command '{}'", new Object[]{"ConsoleCommand", deployConfigRequest.getId(), this.command});
        try {
            String outputLine;
            Process consoleCommand = Runtime.getRuntime().exec(this.command);
            consoleCommand.waitFor();
            int exitValue = consoleCommand.exitValue();
            BufferedReader output = new BufferedReader(new InputStreamReader(consoleCommand.getInputStream()));
            while ((outputLine = output.readLine()) != null) {
                LOG.info("[{} - {}]: {}", new Object[]{"ConsoleCommand", deployConfigRequest.getId(), outputLine});
            }
            if (exitValue != 0) {
                String errorLine;
                BufferedReader errorOut = new BufferedReader(new InputStreamReader(consoleCommand.getErrorStream()));
                while ((errorLine = errorOut.readLine()) != null) {
                    LOG.error("[{} - {}]: {}", new Object[]{"ConsoleCommand", deployConfigRequest.getId(), errorLine});
                }
            }
            LOG.info("[{} - {}]: result for  console command '{}' is {}", new Object[]{"ConsoleCommand", deployConfigRequest.getId(), this.command, exitValue});
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{} - {}]: Failed to run command {} with error {}", new Object[]{"ConsoleCommand", deployConfigRequest.getId(), this.command, e});
            throw new IllegalStateException();
        }
        return Observable.just((Object)deployConfigRequest);
    }
}

