/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import io.vertx.core.Vertx;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.DeployApplicationRequest;
import nl.jpoint.vertx.mod.deploy.util.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class StopApplication
implements Command<DeployApplicationRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(StopApplication.class);
    private static final Long POLLING_INTERVAL_IN_MS = 500L;
    private final LocalDateTime timeout;
    private DeployConfig config;
    private ProcessUtils processUtils;
    private io.vertx.rxjava.core.Vertx rxVertx;

    public StopApplication(Vertx vertx, DeployConfig config) {
        this.config = config;
        this.processUtils = new ProcessUtils(config);
        this.rxVertx = new io.vertx.rxjava.core.Vertx(vertx);
        this.timeout = LocalDateTime.now().plusMinutes(1L);
    }

    @Override
    public Observable<DeployApplicationRequest> executeAsync(DeployApplicationRequest request) {
        LOG.info("[{} - {}]: Waiting for module {} to stop.", new Object[]{"DeployRequest", request.getId(), request.getMavenArtifactId()});
        return Observable.just((Object)request).flatMap(this::stopApplication).flatMap(this::doPoll);
    }

    private Observable<DeployApplicationRequest> stopApplication(DeployApplicationRequest request) {
        LOG.info("[{} - {}]: Stopping application with applicationId '{}'.", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
        try {
            String outputLine;
            Process killProcess = Runtime.getRuntime().exec(new String[]{this.config.getVertxHome().resolve("bin/vertx").toString(), "stop", request.getMavenArtifactId()});
            killProcess.waitFor(1L, TimeUnit.MINUTES);
            int exitValue = killProcess.exitValue();
            BufferedReader output = new BufferedReader(new InputStreamReader(killProcess.getInputStream()));
            while ((outputLine = output.readLine()) != null && !outputLine.isEmpty()) {
                LOG.trace("[{} - {}]: {}", new Object[]{"DeployRequest", request.getId(), outputLine});
            }
            if (exitValue != 0) {
                String errorLine;
                BufferedReader errorOut = new BufferedReader(new InputStreamReader(killProcess.getErrorStream()));
                while ((errorLine = errorOut.readLine()) != null) {
                    LOG.error("[{} - {}]: {}", new Object[]{"DeployRequest", request.getId(), errorLine});
                }
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{} - {}]: Failed to stop module {}", new Object[]{"DeployRequest", request.getId(), request.getModuleId()});
        }
        return Observable.just((Object)request);
    }

    private Observable<DeployApplicationRequest> doPoll(DeployApplicationRequest request) {
        return this.rxVertx.timerStream(POLLING_INTERVAL_IN_MS.longValue()).toObservable().flatMap(x -> this.processUtils.checkModuleRunning(request)).flatMap(result -> {
            if (LocalDateTime.now().isAfter(this.timeout)) {
                LOG.error("[{} - {}]: Timeout while waiting for application to stop. ", (Object)"DeployRequest", (Object)request.getId());
                throw new IllegalStateException();
            }
            if (!request.isRunning()) {
                LOG.info("[{} - {}]: Application {} stopped.", new Object[]{"DeployRequest", request.getId(), request.getMavenArtifactId()});
                return Observable.just((Object)request);
            }
            LOG.info("[{} - {}]: Application {} still running.", new Object[]{"DeployRequest", request.getId(), request.getMavenArtifactId()});
            return this.doPoll(request);
        }).doOnError(t -> LOG.info("[{} - {}]: Error while Waiting for  module '{}' with applicationId '{}' to stop -> '{}'.", new Object[]{"DeployRequest", request.getId(), request.getModuleId(), t}));
    }
}

