/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.handler;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import nl.jpoint.vertx.mod.deploy.request.DeployState;
import nl.jpoint.vertx.mod.deploy.service.AwsService;

public class RestDeployStatusHandler
implements Handler<RoutingContext> {
    private final AwsService deployAwsService;

    public RestDeployStatusHandler(AwsService deployAwsService) {
        this.deployAwsService = deployAwsService;
    }

    public void handle(RoutingContext context) {
        DeployState state = this.deployAwsService.getDeployStatus(context.request().params().get("id"));
        switch (state) {
            case SUCCESS: {
                this.respondOk(context.request());
                break;
            }
            case UNKNOWN: 
            case FAILED: {
                this.respondFailed(context.request());
                break;
            }
            default: {
                this.respondContinue(context.request(), state);
            }
        }
    }

    private void respondOk(HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.OK.code());
        request.response().end();
    }

    private void respondContinue(HttpServerRequest request, DeployState state) {
        request.response().setStatusCode(HttpResponseStatus.ACCEPTED.code());
        request.response().setStatusMessage("Deploy in state : " + state.name());
        request.response().end();
    }

    private void respondFailed(HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        request.response().setStatusMessage("Error");
        request.response().end();
    }
}

