/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.service;

import io.vertx.core.Vertx;
import java.util.Map;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.RunApplication;
import nl.jpoint.vertx.mod.deploy.command.StopApplication;
import nl.jpoint.vertx.mod.deploy.request.DeployApplicationRequest;
import nl.jpoint.vertx.mod.deploy.service.DeployService;
import nl.jpoint.vertx.mod.deploy.util.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class DeployApplicationService
implements DeployService<DeployApplicationRequest, DeployApplicationRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(DeployApplicationService.class);
    private final DeployConfig config;
    private final Map<String, String> installedModules;
    private Vertx vertx;

    public DeployApplicationService(DeployConfig config, Vertx vertx) {
        this.config = config;
        this.vertx = vertx;
        this.installedModules = new ProcessUtils(config).listInstalledAndRunningModules();
    }

    @Override
    public Observable<DeployApplicationRequest> deployAsync(DeployApplicationRequest deployApplicationRequest) {
        return this.resolveSnapShotVersion(deployApplicationRequest).flatMap(this::checkInstalled).flatMap(this::checkRunning).flatMap(request -> {
            if (deployApplicationRequest.isInstalled()) {
                return this.startApplication((DeployApplicationRequest)request);
            }
            return this.stopApplication((DeployApplicationRequest)request).flatMap(this::startApplication).flatMap(this::registerApplication);
        });
    }

    private Observable<DeployApplicationRequest> checkInstalled(DeployApplicationRequest deployApplicationRequest) {
        if (!this.installedModules.containsKey(deployApplicationRequest.getMavenArtifactId())) {
            LOG.info("[{} - {}]: Module ({}) not installed.", new Object[]{"DeployRequest", deployApplicationRequest.getId(), deployApplicationRequest.getModuleId()});
            deployApplicationRequest.setInstalled(false);
        } else {
            String requestedVersion;
            String installedModuleVersion = this.installedModules.get(deployApplicationRequest.getMavenArtifactId());
            boolean sameVersion = installedModuleVersion.equals(requestedVersion = deployApplicationRequest.getSnapshotVersion() != null ? deployApplicationRequest.getSnapshotVersion() : deployApplicationRequest.getVersion());
            if (sameVersion) {
                LOG.info("[{} - {}]: Module ({}) already installed.", new Object[]{"DeployRequest", deployApplicationRequest.getId(), deployApplicationRequest.getModuleId()});
            }
            deployApplicationRequest.setInstalled(sameVersion);
        }
        return Observable.just((Object)deployApplicationRequest);
    }

    private Observable<DeployApplicationRequest> checkRunning(DeployApplicationRequest deployApplicationRequest) {
        new ProcessUtils(this.config).checkModuleRunning(deployApplicationRequest);
        if (!deployApplicationRequest.isRunning()) {
            LOG.info("[{} - {}]: Module ({}) stopped externally.", new Object[]{"DeployRequest", deployApplicationRequest.getId(), deployApplicationRequest.getModuleId()});
        }
        return Observable.just((Object)deployApplicationRequest);
    }

    private Observable<DeployApplicationRequest> stopApplication(DeployApplicationRequest deployApplicationRequest) {
        if (deployApplicationRequest.isRunning()) {
            StopApplication stopApplicationCommand = new StopApplication(this.vertx, this.config);
            return stopApplicationCommand.executeAsync(deployApplicationRequest);
        }
        return Observable.just((Object)deployApplicationRequest);
    }

    private Observable<DeployApplicationRequest> startApplication(DeployApplicationRequest deployApplicationRequest) {
        if (!deployApplicationRequest.isRunning()) {
            RunApplication runModCommand = new RunApplication(this.vertx, this.config);
            return runModCommand.executeAsync(deployApplicationRequest);
        }
        return Observable.just((Object)deployApplicationRequest);
    }

    private Observable<DeployApplicationRequest> registerApplication(DeployApplicationRequest deployApplicationRequest) {
        this.installedModules.put(deployApplicationRequest.getMavenArtifactId(), deployApplicationRequest.getSnapshotVersion() != null ? deployApplicationRequest.getSnapshotVersion() : deployApplicationRequest.getVersion());
        return Observable.just((Object)deployApplicationRequest);
    }

    @Override
    public DeployConfig getConfig() {
        return this.config;
    }

    @Override
    public Vertx getVertx() {
        return this.vertx;
    }

    public Observable<Boolean> stopContainer() {
        LOG.info("Stopping all running modules");
        return Observable.from(this.installedModules.entrySet()).flatMap(entry -> {
            StopApplication stopApplication = new StopApplication(this.vertx, this.config);
            String[] mavenIds = ((String)entry.getKey()).split(":", 2);
            DeployApplicationRequest request = new DeployApplicationRequest(mavenIds[0], mavenIds[1], (String)entry.getValue(), "jar");
            request.setRunning(false);
            request.setInstalled(false);
            return stopApplication.executeAsync(request);
        }).toList().flatMap(x -> Observable.just((Object)true));
    }
}

