/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.service;

import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.Map;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.request.DeployArtifactRequest;
import nl.jpoint.vertx.mod.deploy.service.DeployService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class DeployArtifactService
implements DeployService<DeployArtifactRequest, DeployArtifactRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(DeployArtifactService.class);
    private final Vertx vertx;
    private final DeployConfig config;
    private final Map<String, String> installedArtifacts;

    public DeployArtifactService(Vertx vertx, DeployConfig config) {
        this.vertx = vertx;
        this.config = config;
        this.installedArtifacts = new HashMap<String, String>();
    }

    @Override
    public Observable<DeployArtifactRequest> deployAsync(DeployArtifactRequest deployRequest) {
        return this.resolveSnapShotVersion(deployRequest).flatMap(r -> {
            if (this.versionInstalled(deployRequest)) {
                return Observable.just((Object)r);
            }
            return this.downloadArtifact(r).flatMap(this::parseArtifactContext).flatMap(this::extractArtifact).flatMap(this::addInstalledVersion);
        });
    }

    private boolean versionInstalled(DeployArtifactRequest deployRequest) {
        if (this.installedArtifacts.containsKey(deployRequest.getGroupId() + ":" + deployRequest.getArtifactId()) && this.installedArtifacts.get(deployRequest.getGroupId() + ":" + deployRequest.getArtifactId()).equals(deployRequest.getSnapshotVersion() != null ? deployRequest.getSnapshotVersion() : deployRequest.getVersion())) {
            LOG.info("[{} - {}]: Same SNAPSHOT version ({}) of Artifact {} already installed.", new Object[]{"DeployArtifactRequest", deployRequest.getId(), deployRequest.getSnapshotVersion(), deployRequest.getModuleId()});
            return true;
        }
        return false;
    }

    private Observable<DeployArtifactRequest> addInstalledVersion(DeployArtifactRequest deployArtifactRequest) {
        String installedVersion = deployArtifactRequest.getSnapshotVersion() != null ? deployArtifactRequest.getSnapshotVersion() : deployArtifactRequest.getVersion();
        this.installedArtifacts.put(deployArtifactRequest.getGroupId() + ":" + deployArtifactRequest.getArtifactId(), installedVersion);
        return Observable.just((Object)deployArtifactRequest);
    }

    @Override
    public DeployConfig getConfig() {
        return this.config;
    }

    @Override
    public Vertx getVertx() {
        return this.vertx;
    }
}

