/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.service;

import io.vertx.core.Vertx;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.DownloadArtifact;
import nl.jpoint.vertx.mod.deploy.command.ExtractArtifact;
import nl.jpoint.vertx.mod.deploy.command.ResolveSnapshotVersion;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import nl.jpoint.vertx.mod.deploy.util.ArtifactContextUtil;
import rx.Observable;

public interface DeployService<T extends ModuleRequest, R> {
    public Observable<R> deployAsync(T var1);

    public DeployConfig getConfig();

    public Vertx getVertx();

    default public Observable<T> resolveSnapShotVersion(T moduleRequest) {
        if (((ModuleRequest)moduleRequest).isSnapshot() && !this.getConfig().isMavenLocal()) {
            ResolveSnapshotVersion<T> resolveVersion = new ResolveSnapshotVersion<T>(this.getConfig(), this.getVertx());
            return resolveVersion.executeAsync(moduleRequest);
        }
        return Observable.just(moduleRequest);
    }

    default public Observable<T> downloadArtifact(T moduleRequest) {
        DownloadArtifact<T> downloadArtifact = new DownloadArtifact<T>(this.getConfig(), this.getVertx());
        return downloadArtifact.executeAsync(moduleRequest);
    }

    default public Observable<T> parseArtifactContext(T moduleRequest) {
        ArtifactContextUtil artifactContextUtil = new ArtifactContextUtil(this.getConfig().getArtifactRepo().resolve(((ModuleRequest)moduleRequest).getFileName()));
        ((ModuleRequest)moduleRequest).setRestartCommand(artifactContextUtil.getTestCommand());
        ((ModuleRequest)moduleRequest).setTestCommand(artifactContextUtil.getTestCommand());
        ((ModuleRequest)moduleRequest).setBaseLocation(artifactContextUtil.getBaseLocation());
        return Observable.just(moduleRequest);
    }

    default public Observable<T> extractArtifact(T moduleRequest) {
        ExtractArtifact<T> extractConfig = new ExtractArtifact<T>(this.getVertx(), this.getConfig(), ((ModuleRequest)moduleRequest).getBaseLocation());
        return extractConfig.executeAsync(moduleRequest);
    }
}

