/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.util;

import io.vertx.core.json.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.request.DeployApplicationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class ProcessUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessUtils.class);
    private static final String SELF = "nl.jpoint.vertx-deploy-tools:vertx-deploy:";
    private static final String MAVEN_PATTERN = "maven:([^\\s]+)";
    private static final String MODULE_PATTERN = "([^\\s]+):([^\\s]+):([^\\s]+)";
    private final Path vertxHome;
    private final Pattern mavenPattern;
    private final Pattern modulePattern;

    public ProcessUtils(DeployConfig config) {
        this.vertxHome = config.getVertxHome();
        this.mavenPattern = Pattern.compile(MAVEN_PATTERN);
        this.modulePattern = Pattern.compile(MODULE_PATTERN);
    }

    public Map<String, String> listInstalledAndRunningModules() {
        List<String> moduleIds = this.listModules();
        return moduleIds.stream().map(this::parseModuleString).collect(Collectors.toMap(jsonObject -> jsonObject.getString("maven_id"), jsonObject -> jsonObject.getString("maven_version")));
    }

    private JsonObject parseModuleString(String moduleString) {
        String[] vars;
        JsonObject module = new JsonObject();
        if (moduleString != null && !moduleString.isEmpty() && (vars = moduleString.split(":", 3)).length == 3) {
            module.put("maven_version", vars[2]);
            module.put("maven_id", vars[0] + ":" + vars[1]);
        }
        return module;
    }

    private List<String> listModules() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Process listProcess = Runtime.getRuntime().exec(new String[]{this.vertxHome.resolve("bin/vertx").toString(), "list"});
            listProcess.waitFor(1L, TimeUnit.MINUTES);
            int exitValue = listProcess.exitValue();
            if (exitValue == 0) {
                String outLine;
                BufferedReader out = new BufferedReader(new InputStreamReader(listProcess.getInputStream()));
                while ((outLine = out.readLine()) != null) {
                    String moduleString;
                    String moduleString2;
                    Matcher mavenMatcher = this.mavenPattern.matcher(outLine);
                    if (mavenMatcher.find() && (moduleString2 = mavenMatcher.group(1)).contains(":") && !result.contains(moduleString2) && !moduleString2.contains(SELF)) {
                        result.add(moduleString2);
                        continue;
                    }
                    Matcher moduleMatcher = this.modulePattern.matcher(outLine);
                    if (!moduleMatcher.find() || !(moduleString = moduleMatcher.group(0)).contains(":") || result.contains(moduleString) || moduleString.contains(SELF)) continue;
                    result.add(moduleString);
                }
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.error("[{}]: -  Failed to list modules '{}'", (Object)"Startup", (Object)e.getMessage());
        }
        return result;
    }

    public Observable<DeployApplicationRequest> checkModuleRunning(DeployApplicationRequest request) {
        request.setRunning(this.listInstalledAndRunningModules().containsKey(request.getMavenArtifactId()));
        return Observable.just((Object)request);
    }
}

