/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.aws.state;

import io.vertx.core.Vertx;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import nl.jpoint.vertx.mod.deploy.aws.AwsElbUtil;
import nl.jpoint.vertx.mod.deploy.aws.AwsState;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

class AwsPollingElbStateObservable {
    private static final Logger LOG = LoggerFactory.getLogger(AwsPollingElbStateObservable.class);
    private static final Long POLLING_INTERVAL_IN_MS = 3000L;
    private final io.vertx.rxjava.core.Vertx rxVertx;
    private final AwsElbUtil awsElbUtil;
    private final LocalDateTime timeout;
    private final List<AwsState> acceptedStates;

    public AwsPollingElbStateObservable(Vertx vertx, AwsElbUtil awsElbUtil, LocalDateTime timeout, AwsState ... acceptedStates) {
        this.rxVertx = new io.vertx.rxjava.core.Vertx(vertx);
        this.awsElbUtil = awsElbUtil;
        this.timeout = timeout;
        this.acceptedStates = Arrays.asList(acceptedStates);
    }

    public Observable<DeployRequest> poll(DeployRequest request, String elb) {
        LOG.info("[{} - {}]: Starting instance status poller for instance id {} on loadbalancer {}", new Object[]{"ConfigureAwsElb", request.getId(), request.getInstanceId(), elb});
        return this.doPoll(request, elb);
    }

    private Observable<DeployRequest> doPoll(DeployRequest request, String elb) {
        return this.rxVertx.timerStream(POLLING_INTERVAL_IN_MS.longValue()).toObservable().flatMap(x -> this.awsElbUtil.pollForInstanceState(request.getInstanceId(), elb)).flatMap(awsState -> {
            if (LocalDateTime.now().isAfter(this.timeout)) {
                LOG.error("[{} - {}]: Timeout while waiting for instance to reach {} ", new Object[]{"ConfigureAwsElb", request.getId(), awsState.name()});
                throw new IllegalStateException();
            }
            LOG.info("[{} - {}]: Instance {} on elb {} in state {}", new Object[]{"ConfigureAwsElb", request.getId(), request.getInstanceId(), elb, awsState.name()});
            if (this.acceptedStates.contains(awsState)) {
                return Observable.just((Object)request);
            }
            return this.doPoll(request, elb);
        });
    }
}

