/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.request;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.UUID;

public abstract class ModuleRequest {
    private final UUID id = UUID.randomUUID();
    private final String groupId;
    private final String artifactId;
    private final String classifier;
    private final String type;
    private final boolean snapshot;
    private String version;
    private String remoteBase;
    private boolean restart = false;
    private Optional<String> restartCommand;
    private Optional<String> testCommand;
    private Path baseLocation;

    ModuleRequest(String groupId, String artifactId, String version, String classifier, String type) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.type = type != null ? type : "jar";
        this.snapshot = version.endsWith("-SNAPSHOT");
        this.remoteBase = groupId.replaceAll("\\.", "/") + "/" + artifactId + "/" + version + "/";
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public UUID getId() {
        return this.id;
    }

    public String getModuleId() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String getMavenArtifactId() {
        return this.groupId + ":" + this.artifactId;
    }

    public String getRemoteLocation() {
        return this.remoteBase + this.getFileName();
    }

    public String getFileName() {
        StringBuilder builder = new StringBuilder().append(this.getArtifactId()).append("-");
        if (this.classifier != null && !this.classifier.isEmpty()) {
            builder.append("-").append(this.classifier);
        }
        builder.append(this.version);
        builder.append(".");
        builder.append(this.type);
        return builder.toString();
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public String getMetadataLocation() {
        return this.remoteBase + "maven-metadata.xml";
    }

    public String getType() {
        return this.type;
    }

    public boolean restart() {
        return this.restart;
    }

    public void setRestart(boolean restart) {
        this.restart = restart;
    }

    public Optional<String> getRestartCommand() {
        return this.restartCommand;
    }

    public void setRestartCommand(String restartCommand) {
        this.restartCommand = restartCommand == null || restartCommand.isEmpty() ? Optional.empty() : Optional.of(restartCommand);
    }

    public Optional<String> getTestCommand() {
        return this.testCommand;
    }

    public void setTestCommand(String testCommand) {
        this.testCommand = testCommand == null || testCommand.isEmpty() ? Optional.empty() : Optional.of(testCommand);
    }

    public Path getBaseLocation() {
        return this.baseLocation;
    }

    public void setBaseLocation(String baseLocation) {
        this.baseLocation = Paths.get(baseLocation, new String[0]);
    }

    public abstract boolean deleteBase();

    public abstract boolean checkConfig();

    public abstract String getLogName();
}

