/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.util;

import io.vertx.rxjava.core.Vertx;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class ObservableCommand<R extends ModuleRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ObservableCommand.class);
    private static final Long POLLING_INTERVAL_IN_MS = 500L;
    private static Process process;
    private final Integer expectedResultCode;
    private final Vertx rxVertx;
    private final R request;

    public ObservableCommand(R request, Integer expectedResultCode, Vertx vertx) {
        this.request = request;
        this.expectedResultCode = expectedResultCode;
        this.rxVertx = vertx;
    }

    public Observable<R> execute(ProcessBuilder builder) {
        return this.observableCommand(builder).flatMap(x -> this.waitForExit()).flatMap(x -> {
            if (process.exitValue() != this.expectedResultCode.intValue()) {
                throw new IllegalStateException("Error executing process");
            }
            return Observable.just(this.request);
        });
    }

    private Observable<Integer> waitForExit() {
        return this.rxVertx.timerStream(POLLING_INTERVAL_IN_MS.longValue()).toObservable().flatMap(x -> this.pollProcess());
    }

    private Observable<Integer> pollProcess() {
        if (process.isAlive()) {
            return this.pollProcess();
        }
        if (process.exitValue() != this.expectedResultCode.intValue()) {
            throw new IllegalStateException("Error while executing process");
        }
        return Observable.just((Object)process.exitValue());
    }

    private Observable<String> observableCommand(ProcessBuilder builder) {
        return Observable.create(subscriber -> {
            process = null;
            try {
                process = builder.start();
            }
            catch (IOException e) {
                subscriber.onError((Throwable)e);
            }
            if (process != null) {
                InputStream stream = process.getInputStream();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        LOG.trace("[{} - {}]: Command output -> '{}'", new Object[]{"ConsoleCommand", ((ModuleRequest)this.request).getId(), line});
                    }
                    process.destroy();
                    subscriber.onCompleted();
                }
                catch (Exception e) {
                    subscriber.onError((Throwable)e);
                }
            } else {
                subscriber.onError((Throwable)new IllegalStateException("Unable to create process"));
            }
        });
    }
}

