/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.autoscaling.AmazonAutoScalingAsyncClient;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.autoscaling.model.AutoScalingInstanceDetails;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesResult;
import com.amazonaws.services.autoscaling.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.autoscaling.model.EnterStandbyRequest;
import com.amazonaws.services.autoscaling.model.ExitStandbyRequest;
import com.amazonaws.services.autoscaling.model.LoadBalancerState;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import nl.jpoint.vertx.mod.deploy.aws.AwsContext;
import nl.jpoint.vertx.mod.deploy.aws.AwsException;
import nl.jpoint.vertx.mod.deploy.aws.AwsState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class AwsAutoScalingUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AwsAutoScalingUtil.class);
    private final AmazonAutoScalingClient asClient;
    private final AmazonAutoScalingAsyncClient asyncClient;

    public AwsAutoScalingUtil(AwsContext context) {
        this.asClient = new AmazonAutoScalingClient(context.getCredentials());
        this.asClient.setRegion(context.getAwsRegion());
        this.asyncClient = new AmazonAutoScalingAsyncClient(context.getCredentials());
        this.asyncClient.setRegion(context.getAwsRegion());
    }

    public Observable<AwsState> pollForInstanceState(String instanceId) throws AwsException {
        try {
            return Observable.from((Future)this.asyncClient.describeAutoScalingInstancesAsync(new DescribeAutoScalingInstancesRequest().withInstanceIds(new String[]{instanceId}))).flatMap(result -> {
                Optional<String> optState = result.getAutoScalingInstances().stream().filter(i -> i.getInstanceId().equals(instanceId)).map(AutoScalingInstanceDetails::getLifecycleState).findFirst();
                return Observable.just((Object)((Object)(optState.isPresent() ? AwsState.map(optState.get()) : AwsState.UNKNOWN)));
            });
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            throw new AwsException(e);
        }
    }

    public Observable<String> listLoadBalancers(String groupId) throws AwsException {
        try {
            return Observable.from((Future)this.asyncClient.describeLoadBalancersAsync(new DescribeLoadBalancersRequest().withAutoScalingGroupName(groupId))).map(result -> result.getLoadBalancers().stream().map(LoadBalancerState::getLoadBalancerName).collect(Collectors.toList())).flatMap(Observable::from);
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            throw new AwsException(e);
        }
    }

    public boolean enterStandby(String instanceId, String groupId, boolean decrementDesiredCapacity) {
        try {
            DescribeAutoScalingInstancesResult result = this.asClient.describeAutoScalingInstances(new DescribeAutoScalingInstancesRequest().withMaxRecords(Integer.valueOf(1)).withInstanceIds(new String[]{instanceId}));
            Optional<AutoScalingInstanceDetails> state = result.getAutoScalingInstances().stream().filter(asi -> asi.getInstanceId().equals(instanceId)).findFirst();
            state.ifPresent(s -> LOG.trace("enterStandby() instance {} current state : {}", (Object)instanceId, (Object)s.getLifecycleState()));
            if (state.isPresent() && state.get().getLifecycleState().equalsIgnoreCase(AwsState.STANDBY.name())) {
                return true;
            }
            this.asClient.enterStandby(new EnterStandbyRequest().withAutoScalingGroupName(groupId).withInstanceIds(new String[]{instanceId}).withShouldDecrementDesiredCapacity(Boolean.valueOf(decrementDesiredCapacity)));
            return true;
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            return false;
        }
    }

    public boolean exitStandby(String instanceId, String groupId) {
        try {
            this.asClient.exitStandby(new ExitStandbyRequest().withAutoScalingGroupName(groupId).withInstanceIds(new String[]{instanceId}));
            return true;
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            return false;
        }
    }
}

