/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import io.vertx.core.Vertx;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.DeployConfigRequest;
import nl.jpoint.vertx.mod.deploy.util.ObservableCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class RunConsoleCommand
implements Command<DeployConfigRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(RunConsoleCommand.class);
    private final String command;
    private final io.vertx.rxjava.core.Vertx rxVertx;

    public RunConsoleCommand(Vertx vertx, String command) {
        this.command = command;
        this.rxVertx = new io.vertx.rxjava.core.Vertx(vertx);
    }

    @Override
    public Observable<DeployConfigRequest> executeAsync(DeployConfigRequest deployConfigRequest) {
        if (this.command == null || this.command.isEmpty()) {
            LOG.error("[{} - {}]: Failed to run empty command.", (Object)"ConsoleCommand", (Object)deployConfigRequest.getId());
            throw new IllegalStateException();
        }
        ObservableCommand<DeployConfigRequest> observableCommand = new ObservableCommand<DeployConfigRequest>(deployConfigRequest, 0, this.rxVertx);
        return observableCommand.execute(new ProcessBuilder(new String[0]).command(this.command)).doOnCompleted(() -> LOG.info("[{} - {}]: Finished running console command '{}'.", new Object[]{"ConsoleCommand", deployConfigRequest.getId(), this.command})).doOnError(t -> LOG.error("[{} - {}]: Failed to run command {} with error {}", new Object[]{"ConsoleCommand", deployConfigRequest.getId(), this.command, t}));
    }
}

