/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.handler;

import com.amazonaws.util.StringUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.Optional;
import nl.jpoint.vertx.mod.deploy.handler.RestDeployModuleHandler;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployState;
import nl.jpoint.vertx.mod.deploy.service.AwsService;
import nl.jpoint.vertx.mod.deploy.service.DeployApplicationService;
import nl.jpoint.vertx.mod.deploy.service.DeployArtifactService;
import nl.jpoint.vertx.mod.deploy.service.DeployConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class RestDeployHandler
implements Handler<RoutingContext> {
    private final DeployApplicationService applicationApplicationService;
    private final DeployArtifactService artifactDeployService;
    private final DeployConfigService configDeployService;
    private final Optional<AwsService> awsService;
    private final String authToken;
    private final Logger LOG = LoggerFactory.getLogger(RestDeployModuleHandler.class);

    public RestDeployHandler(DeployApplicationService deployApplicationService, DeployArtifactService artifactDeployService, DeployConfigService configDeployService, AwsService awsService, String authToken) {
        this.applicationApplicationService = deployApplicationService;
        this.artifactDeployService = artifactDeployService;
        this.configDeployService = configDeployService;
        this.awsService = Optional.ofNullable(awsService);
        this.authToken = authToken;
    }

    public void handle(RoutingContext context) {
        context.request().bodyHandler(buffer -> {
            DeployRequest deployRequest;
            ObjectReader reader = new ObjectMapper().readerFor(DeployRequest.class);
            if (StringUtils.isNullOrEmpty((String)context.request().getHeader("authToken")) || !this.authToken.equals(context.request().getHeader("authToken"))) {
                this.LOG.error("{}: Invalid authToken in request.", (Object)"DeployRequest");
                this.respondFailed(null, context.request(), "Invalid authToken in request.");
                return;
            }
            String eventBody = new String(buffer.getBytes());
            if (eventBody.isEmpty()) {
                this.LOG.error("{}: No postdata in request.", (Object)"DeployRequest");
                this.respondFailed(null, context.request(), "No postdata in request.");
                return;
            }
            this.LOG.debug("{}: received postdata -> {} ", (Object)"DeployRequest", (Object)eventBody);
            try {
                deployRequest = (DeployRequest)reader.readValue(eventBody);
            }
            catch (IOException e) {
                this.LOG.error("{}: Error while reading post data -> {}.", (Object)"DeployRequest", (Object)e.getMessage());
                this.respondFailed(null, context.request(), "Error wile reading post data -> " + e.getMessage());
                return;
            }
            this.LOG.info("[{} - {}]: Received deploy request with {} config(s), {} module(s) and {} artifact(s) ", new Object[]{"DeployRequest", deployRequest.getId().toString(), deployRequest.getConfigs() != null ? deployRequest.getConfigs().size() : 0, deployRequest.getModules() != null ? deployRequest.getModules().size() : 0, deployRequest.getArtifacts() != null ? deployRequest.getArtifacts().size() : 0});
            Observable.just((Object)deployRequest).flatMap(this::registerRequest).flatMap(r -> this.respondContinue((DeployRequest)r, context.request())).flatMap(this::deRegisterInstanceFromAutoScalingGroup).flatMap(this::deRegisterInstanceFromLoadBalancer).flatMap(this::deployConfigs).flatMap(this::deployArtifacts).flatMap(this::stopContainer).flatMap(this::deployApplications).flatMap(this::registerInstanceInAutoScalingGroup).flatMap(this::checkElbStatus).doOnCompleted(() -> this.respond(deployRequest, context.request())).doOnError(t -> this.respondFailed(deployRequest.getId().toString(), context.request(), t.getMessage())).subscribe();
        });
    }

    private Observable<DeployRequest> deRegisterInstanceFromLoadBalancer(DeployRequest deployRequest) {
        if (deployRequest.withElb() && !deployRequest.withAutoScaling() && this.awsService.isPresent()) {
            return this.awsService.get().loadBalancerDeRegisterInstance(deployRequest);
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> registerRequest(DeployRequest deployRequest) {
        if (deployRequest.withElb()) {
            this.awsService.ifPresent(service -> service.registerRequest(deployRequest));
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> respondContinue(DeployRequest deployRequest, HttpServerRequest request) {
        if (deployRequest.withElb()) {
            request.response().setStatusMessage(deployRequest.getId().toString());
            request.response().end(deployRequest.getId().toString());
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> deRegisterInstanceFromAutoScalingGroup(DeployRequest deployRequest) {
        if (deployRequest.withAutoScaling() && this.awsService.isPresent()) {
            return this.awsService.get().autoScalingDeRegisterInstance(deployRequest);
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> deployConfigs(DeployRequest deployRequest) {
        this.awsService.ifPresent(aws -> aws.updateAndGetRequest(DeployState.DEPLOYING_CONFIGS, deployRequest.getId().toString()));
        if (deployRequest.getConfigs() != null && !deployRequest.getConfigs().isEmpty()) {
            return Observable.from(deployRequest.getConfigs()).flatMap(this.configDeployService::deployAsync).toList().flatMap(list -> {
                if (list.contains(Boolean.TRUE)) {
                    deployRequest.setRestart(true);
                }
                return Observable.just((Object)deployRequest);
            });
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> deployArtifacts(DeployRequest deployRequest) {
        this.awsService.ifPresent(aws -> aws.updateAndGetRequest(DeployState.DEPLOYING_ARTIFACTS, deployRequest.getId().toString()));
        if (deployRequest.getArtifacts() != null && !deployRequest.getArtifacts().isEmpty()) {
            return Observable.from(deployRequest.getArtifacts()).flatMap(this.artifactDeployService::deployAsync).toList().flatMap(x -> Observable.just((Object)deployRequest));
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> stopContainer(DeployRequest deployRequest) {
        this.awsService.ifPresent(aws -> aws.updateAndGetRequest(DeployState.STOPPING_CONTAINER, deployRequest.getId().toString()));
        if (deployRequest.withRestart()) {
            return this.applicationApplicationService.stopContainer().flatMap(x -> Observable.just((Object)deployRequest));
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> deployApplications(DeployRequest deployRequest) {
        this.awsService.ifPresent(aws -> aws.updateAndGetRequest(DeployState.DEPLOYING_APPLICATIONS, deployRequest.getId().toString()));
        if (deployRequest.getModules() != null && !deployRequest.getModules().isEmpty()) {
            return Observable.from(deployRequest.getModules()).flatMap(this.applicationApplicationService::deployAsync).toList().flatMap(x -> Observable.just((Object)deployRequest));
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> registerInstanceInAutoScalingGroup(DeployRequest deployRequest) {
        if (deployRequest.withAutoScaling() && this.awsService.isPresent()) {
            return this.awsService.get().autoScalingRegisterInstance(deployRequest);
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> checkElbStatus(DeployRequest deployRequest) {
        if (deployRequest.withElb() && this.awsService.isPresent()) {
            return this.awsService.get().loadBalancerRegisterInstance(deployRequest);
        }
        return Observable.just((Object)deployRequest);
    }

    private void respond(DeployRequest deployRequest, HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.OK.code());
        this.awsService.ifPresent(aws -> aws.updateAndGetRequest(DeployState.SUCCESS, deployRequest.getId().toString()));
        if (!deployRequest.withElb() && !deployRequest.withAutoScaling()) {
            request.response().end();
        }
    }

    private void respondFailed(String id, HttpServerRequest request, String message) {
        request.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        if (message != null) {
            request.response().end(message);
        } else {
            request.response().end();
        }
        if (id != null) {
            this.awsService.ifPresent(aws -> aws.failBuild(id));
        }
    }
}

