/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingAsyncClient;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import com.amazonaws.services.elasticloadbalancing.model.InstanceState;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import java.util.Optional;
import java.util.concurrent.Future;
import nl.jpoint.vertx.mod.deploy.aws.AwsContext;
import nl.jpoint.vertx.mod.deploy.aws.AwsException;
import nl.jpoint.vertx.mod.deploy.aws.AwsState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class AwsElbUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AwsElbUtil.class);
    private final AmazonElasticLoadBalancingAsyncClient elbAsyncClient;

    public AwsElbUtil(AwsContext context) {
        this.elbAsyncClient = new AmazonElasticLoadBalancingAsyncClient(context.getCredentials());
        this.elbAsyncClient.setRegion(context.getAwsRegion());
    }

    public Observable<String> registerInstanceWithLoadBalancer(String instanceId, String loadBalancer) throws AwsException {
        if (instanceId == null || loadBalancer == null) {
            LOG.error("Unable to register instance {}, on load balancer {}.", (Object)instanceId, (Object)loadBalancer);
            throw new IllegalStateException();
        }
        try {
            return Observable.from((Future)this.elbAsyncClient.registerInstancesWithLoadBalancerAsync(new RegisterInstancesWithLoadBalancerRequest().withLoadBalancerName(loadBalancer).withInstances(new Instance[]{new Instance().withInstanceId(instanceId)}))).flatMap(x -> Observable.just((Object)loadBalancer));
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            throw new AwsException(e);
        }
    }

    public Observable<String> deRegisterInstanceFromLoadbalancer(String instanceId, String loadBalancer) throws AwsException {
        if (instanceId == null || loadBalancer == null) {
            LOG.error("Unable to register instance {}, on load balancer {}.", (Object)instanceId, (Object)loadBalancer);
            throw new IllegalStateException();
        }
        try {
            return Observable.from((Future)this.elbAsyncClient.deregisterInstancesFromLoadBalancerAsync(new DeregisterInstancesFromLoadBalancerRequest().withLoadBalancerName(loadBalancer).withInstances(new Instance[]{new Instance().withInstanceId(instanceId)}))).flatMap(x -> Observable.just((Object)loadBalancer));
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            throw new AwsException(e);
        }
    }

    public Observable<AwsState> pollForInstanceState(String instanceId, String loadBalancer) throws AwsException {
        try {
            return Observable.from((Future)this.elbAsyncClient.describeInstanceHealthAsync(new DescribeInstanceHealthRequest().withLoadBalancerName(loadBalancer).withInstances(new Instance[]{new Instance().withInstanceId(instanceId)}))).flatMap(result -> {
                Optional<InstanceState> state = result.getInstanceStates().stream().filter(i -> i.getInstanceId().equals(instanceId)).findFirst();
                return Observable.just((Object)((Object)(state.isPresent() ? AwsState.map(state.get().getState()) : AwsState.UNKNOWN)));
            });
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            throw new AwsException(e);
        }
    }
}

