/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import nl.jpoint.vertx.mod.deploy.request.DeployApplicationRequest;
import nl.jpoint.vertx.mod.deploy.service.DeployApplicationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestDeployModuleHandler
implements Handler<RoutingContext> {
    private final DeployApplicationService service;
    private final Logger LOG = LoggerFactory.getLogger(RestDeployModuleHandler.class);

    public RestDeployModuleHandler(DeployApplicationService service) {
        this.service = service;
    }

    public void handle(RoutingContext context) {
        context.request().bodyHandler(buffer -> {
            DeployApplicationRequest deployRequest;
            String postData = new String(buffer.getBytes());
            if (postData.isEmpty()) {
                this.LOG.error("{}: No postdata in request.", (Object)"DeployRequest");
                context.request().response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code());
                context.request().response().end();
                return;
            }
            try {
                deployRequest = (DeployApplicationRequest)new ObjectMapper().readerFor(DeployApplicationRequest.class).readValue(postData);
            }
            catch (IOException e) {
                this.LOG.error("[{}]: Failed to read postdata {}", (Object)postData);
                this.respondFailed(context.request());
                return;
            }
            this.LOG.info("[{} - {}]: Received deploy module {}", new Object[]{"DeployRequest", deployRequest.getId().toString(), deployRequest.toString()});
            this.service.deployAsync(deployRequest).doOnCompleted(() -> this.respondOk(context.request())).doOnError(t -> this.respondFailed(context.request()));
        });
    }

    private void respondOk(HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.OK.code());
        request.response().end();
    }

    private void respondFailed(HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        request.response().end();
    }
}

