/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.handler;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import nl.jpoint.vertx.mod.deploy.request.DeployState;
import nl.jpoint.vertx.mod.deploy.service.AwsService;
import nl.jpoint.vertx.mod.deploy.service.DeployApplicationService;
import nl.jpoint.vertx.mod.deploy.util.ApplicationDeployState;
import nl.jpoint.vertx.mod.deploy.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestDeployStatusHandler
implements Handler<RoutingContext> {
    private final Logger LOG = LoggerFactory.getLogger(RestDeployStatusHandler.class);
    private final AwsService deployAwsService;
    private final DeployApplicationService deployApplicationService;

    public RestDeployStatusHandler(AwsService deployAwsService, DeployApplicationService deployApplicationService) {
        this.deployAwsService = deployAwsService;
        this.deployApplicationService = deployApplicationService;
    }

    public void handle(RoutingContext context) {
        DeployState state;
        DeployState deployState = state = this.deployAwsService != null ? this.deployAwsService.getDeployStatus(context.request().params().get("id")) : DeployState.SUCCESS;
        if (!this.deployApplicationService.getDeployedApplicationsFailed().isEmpty()) {
            this.LOG.error("Some services failed to start, failing build");
            state = DeployState.FAILED;
            if (this.deployAwsService != null) {
                this.deployAwsService.failAllRunningRequests();
            }
        }
        switch (state != null ? state : DeployState.CONTINUE) {
            case SUCCESS: {
                this.respondOk(context.request());
                this.deployApplicationService.cleanup();
                break;
            }
            case UNKNOWN: 
            case FAILED: {
                this.respondFailed(context.request());
                this.deployApplicationService.cleanup();
                break;
            }
            default: {
                this.respondContinue(context.request(), state);
            }
        }
    }

    private void respondOk(HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.OK.code());
        request.response().end(this.createStatusObject().encode());
    }

    private void respondContinue(HttpServerRequest request, DeployState state) {
        request.response().setStatusCode(HttpResponseStatus.ACCEPTED.code());
        request.response().setStatusMessage("Deploy in state : " + state.name());
        request.response().end();
    }

    private void respondFailed(HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        request.response().end(this.createStatusObject().encode());
    }

    private JsonObject createStatusObject() {
        JsonObject result = new JsonObject();
        result.put(ApplicationDeployState.OK.name(), HttpUtils.toArray(this.deployApplicationService.getDeployedApplicationsSuccess()));
        result.put(ApplicationDeployState.ERROR.name(), HttpUtils.toArray(this.deployApplicationService.getDeployedApplicationsFailed()));
        return result;
    }
}

