/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.aws.state;

import io.vertx.core.Vertx;
import java.time.LocalDateTime;
import nl.jpoint.vertx.mod.deploy.aws.AwsAutoScalingUtil;
import nl.jpoint.vertx.mod.deploy.aws.AwsContext;
import nl.jpoint.vertx.mod.deploy.aws.AwsState;
import nl.jpoint.vertx.mod.deploy.aws.state.AwsElbRegisterInstance;
import nl.jpoint.vertx.mod.deploy.aws.state.AwsPollingAsStateObservable;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class AwsAsRegisterInstance
implements Command<DeployRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(AwsElbRegisterInstance.class);
    private final AwsAutoScalingUtil awsAsUtil;
    private final AwsPollingAsStateObservable poller;

    public AwsAsRegisterInstance(Vertx vertx, AwsContext awsContext, Integer maxDuration) {
        this.awsAsUtil = new AwsAutoScalingUtil(awsContext);
        this.poller = new AwsPollingAsStateObservable(vertx, this.awsAsUtil, LocalDateTime.now().plusMinutes(maxDuration.intValue()), AwsState.INSERVICE);
    }

    @Override
    public Observable<DeployRequest> executeAsync(DeployRequest request) {
        if (!this.awsAsUtil.exitStandby(request.getAutoScalingGroup())) {
            LOG.error("[{} - {}]: InstanceId {} failed to exit standby in auto scaling group {}", new Object[]{"ConfigureAwsAutoScaling", request.getId(), request.getInstanceId(), request.getAutoScalingGroup()});
            throw new IllegalStateException();
        }
        LOG.info("[{} - {}]: Waiting for instance {} status in auto scaling group {} to reach {}.", new Object[]{"ConfigureAwsAutoScaling", request.getId(), request.getInstanceId(), request.getAutoScalingGroup(), AwsState.INSERVICE});
        LOG.info("[{} - {}]: Starting instance status poller for instance id {} in auto scaling group {}", new Object[]{"ConfigureAwsAutoScaling", request.getId(), request.getInstanceId(), request.getAutoScalingGroup()});
        return this.poller.poll(request);
    }
}

