/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.aws.state;

import io.vertx.core.Vertx;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import nl.jpoint.vertx.mod.deploy.aws.AwsAutoScalingUtil;
import nl.jpoint.vertx.mod.deploy.aws.AwsState;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

class AwsPollingAsStateObservable {
    private static final Logger LOG = LoggerFactory.getLogger(AwsPollingAsStateObservable.class);
    private static final Long POLLING_INTERVAL_IN_MS = 3000L;
    private final io.vertx.rxjava.core.Vertx rxVertx;
    private final AwsAutoScalingUtil awsAsUtil;
    private final LocalDateTime timeout;
    private final List<AwsState> acceptedStates;

    public AwsPollingAsStateObservable(Vertx vertx, AwsAutoScalingUtil awsAsUtil, LocalDateTime timeout, AwsState ... acceptedStates) {
        this.rxVertx = new io.vertx.rxjava.core.Vertx(vertx);
        this.awsAsUtil = awsAsUtil;
        this.timeout = timeout;
        this.acceptedStates = Arrays.asList(acceptedStates);
    }

    public Observable<DeployRequest> poll(DeployRequest request) {
        LOG.info("[{} - {}]: Setting timeout to {}.", new Object[]{"ConfigureAwsAutoScaling", request.getId(), this.timeout.toString()});
        return this.doPoll(request);
    }

    private Observable<DeployRequest> doPoll(DeployRequest request) {
        return this.rxVertx.timerStream(POLLING_INTERVAL_IN_MS.longValue()).toObservable().flatMap(x -> this.awsAsUtil.pollForInstanceState()).flatMap(awsState -> {
            if (LocalDateTime.now().isAfter(this.timeout)) {
                LOG.error("[{} - {}]: Timeout while waiting for instance to reach {} ", new Object[]{"ConfigureAwsAutoScaling", request.getId(), awsState.name()});
                throw new IllegalStateException();
            }
            LOG.info("[{} - {}]: Instance {} in auto scaling group {} in state {}", new Object[]{"ConfigureAwsAutoScaling", request.getId(), request.getInstanceId(), request.getAutoScalingGroup(), awsState.name()});
            if (this.acceptedStates.contains(awsState)) {
                return Observable.just((Object)request);
            }
            return this.doPoll(request);
        });
    }
}

