/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.service;

import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.Map;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.aws.state.AwsAsDeRegisterInstance;
import nl.jpoint.vertx.mod.deploy.aws.state.AwsAsRegisterInstance;
import nl.jpoint.vertx.mod.deploy.aws.state.AwsElbDeRegisterInstance;
import nl.jpoint.vertx.mod.deploy.aws.state.AwsElbRegisterInstance;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class AwsService {
    private static final Logger LOG = LoggerFactory.getLogger(AwsService.class);
    private final Vertx vertx;
    private final DeployConfig config;
    private final Map<String, DeployRequest> runningRequests = new HashMap<String, DeployRequest>();

    public AwsService(Vertx vertx, DeployConfig config) {
        this.vertx = vertx;
        this.config = config;
    }

    public void registerRequest(DeployRequest deployRequest) {
        if (this.runningRequests.containsKey(deployRequest.getId().toString())) {
            LOG.error("[{} - {}]: Request already registered.", (Object)"ConfigureAwsElb", (Object)deployRequest.getId());
            throw new IllegalStateException("Request already registered.");
        }
        this.runningRequests.put(deployRequest.getId().toString(), deployRequest);
    }

    public Observable<DeployRequest> autoScalingDeRegisterInstance(DeployRequest deployRequest) {
        if (!this.runningRequests.containsKey(deployRequest.getId().toString())) {
            LOG.error("[{} - {}]: Request not registered.", (Object)"ConfigureAwsElb", (Object)deployRequest.getId().toString());
            this.failBuild(deployRequest.getId().toString());
            throw new IllegalStateException();
        }
        this.updateAndGetRequest(DeployState.WAITING_FOR_AS_DEREGISTER, deployRequest.getId().toString());
        AwsAsDeRegisterInstance deRegisterFromAsGroup = new AwsAsDeRegisterInstance(this.vertx, this.config, this.config.getAwsMaxRegistrationDuration());
        return deRegisterFromAsGroup.executeAsync(deployRequest);
    }

    public Observable<DeployRequest> autoScalingRegisterInstance(DeployRequest deployRequest) {
        if (!this.runningRequests.containsKey(deployRequest.getId().toString())) {
            LOG.error("[{} - {}]: Request not registered.", (Object)"ConfigureAwsElb", (Object)deployRequest.getId().toString());
            this.failBuild(deployRequest.getId().toString());
            throw new IllegalStateException();
        }
        this.updateAndGetRequest(DeployState.WAITING_FOR_AS_REGISTER, deployRequest.getId().toString());
        AwsAsRegisterInstance register = new AwsAsRegisterInstance(this.vertx, this.config, this.config.getAwsMaxRegistrationDuration());
        return register.executeAsync(deployRequest);
    }

    public Observable<DeployRequest> loadBalancerRegisterInstance(DeployRequest deployRequest) {
        if (!this.runningRequests.containsKey(deployRequest.getId().toString())) {
            LOG.error("[{} - {}]: Request not registered.", (Object)"ConfigureAwsElb", (Object)deployRequest.getId().toString());
            this.failBuild(deployRequest.getId().toString());
            throw new IllegalStateException();
        }
        this.updateAndGetRequest(DeployState.WAITING_FOR_ELB_REGISTER, deployRequest.getId().toString());
        AwsElbRegisterInstance register = new AwsElbRegisterInstance(this.vertx, deployRequest.getId().toString(), this.config, s -> this.runningRequests.containsKey(s) && (!DeployState.FAILED.equals((Object)this.runningRequests.get(s).getState()) || !DeployState.SUCCESS.equals((Object)this.runningRequests.get(s).getState())));
        return register.executeAsync(deployRequest);
    }

    public Observable<DeployRequest> loadBalancerDeRegisterInstance(DeployRequest deployRequest) {
        if (!this.runningRequests.containsKey(deployRequest.getId().toString())) {
            LOG.error("[{} - {}]: Request not registered.", (Object)"ConfigureAwsElb", (Object)deployRequest.getId().toString());
            this.failBuild(deployRequest.getId().toString());
            throw new IllegalStateException();
        }
        this.updateAndGetRequest(DeployState.WAITING_FOR_ELB_DEREGISTER, deployRequest.getId().toString());
        AwsElbDeRegisterInstance register = new AwsElbDeRegisterInstance(this.vertx, this.config);
        return register.executeAsync(deployRequest);
    }

    public DeployRequest updateAndGetRequest(DeployState state, String buildId) {
        if (this.runningRequests.containsKey(buildId) && !DeployState.FAILED.equals((Object)this.runningRequests.get(buildId).getState())) {
            LOG.info("[{} - {}]: Updating state to {}", new Object[]{"ConfigureAwsElb", buildId, state});
            this.runningRequests.get(buildId).setState(state);
            return this.runningRequests.get(buildId);
        }
        return null;
    }

    public void failBuild(String buildId) {
        LOG.error("[{} - {}]: Failing build.", (Object)"ConfigureAwsElb", (Object)buildId);
        if (this.runningRequests.containsKey(buildId)) {
            this.runningRequests.get(buildId).setState(DeployState.FAILED);
        }
    }

    public DeployState getDeployStatus(String deployId) {
        if (!this.runningRequests.containsKey(deployId)) {
            return DeployState.UNKNOWN;
        }
        DeployState state = this.runningRequests.get(deployId).getState();
        if (DeployState.SUCCESS.equals((Object)state) || DeployState.FAILED.equals((Object)state)) {
            this.runningRequests.remove(deployId);
        }
        return state;
    }

    public void failAllRunningRequests() {
        this.runningRequests.forEach((id, r) -> r.setState(DeployState.FAILED));
    }
}

