/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.util;

import io.vertx.core.http.HttpClientOptions;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.core.http.HttpClient;
import io.vertx.rxjava.core.http.HttpClientRequest;
import io.vertx.rxjava.core.http.HttpClientResponse;
import java.net.URI;
import java.util.Base64;
import java.util.UUID;
import java.util.function.Consumer;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;

public class RxHttpUtil {
    private final Logger LOG = LoggerFactory.getLogger(RxHttpUtil.class);
    private final Vertx rxVertx;
    private final DeployConfig config;
    private final HttpClient httpClient;

    public RxHttpUtil(Vertx rxVertx, DeployConfig config) {
        this.rxVertx = rxVertx;
        this.config = config;
        HttpClientOptions options = new HttpClientOptions().setSsl(config.getNexusUrl().getScheme().equals("https")).setVerifyHost(true);
        this.httpClient = rxVertx.createHttpClient(options);
    }

    public Observable<HttpClientResponse> get(UUID id, URI location, String filename) {
        return this.executeGet(this.httpClient.getAbs(location.toString()), HttpClientRequest::end, filename).doOnError(t -> this.LOG.error("[{}]: Error downloading file {} from location {}, {}", new Object[]{id.toString(), filename, location.toString(), t.getMessage()}));
    }

    private Observable<HttpClientResponse> executeGet(HttpClientRequest request, Consumer<HttpClientRequest> requestFiller, String filename) {
        return Observable.create(onsubscribe -> {
            request.handler(response -> this.responseHandler((HttpClientResponse)response, (Observer<? super HttpClientResponse>)onsubscribe, filename)).exceptionHandler(arg_0 -> ((Subscriber)onsubscribe).onError(arg_0));
            if (this.config.isHttpAuthentication()) {
                this.setAuthorizationHeader(request);
            }
            requestFiller.accept(request);
        });
    }

    private void responseHandler(HttpClientResponse response, Observer<? super HttpClientResponse> subscriber, String filename) {
        response.exceptionHandler(arg_0 -> subscriber.onError(arg_0));
        response.bodyHandler(bodyBuffer -> {
            this.rxVertx.fileSystem().writeFileBlocking(filename, bodyBuffer);
            subscriber.onNext((Object)response);
            subscriber.onCompleted();
        });
    }

    private void setAuthorizationHeader(HttpClientRequest httpClientRequest) {
        String usernameAndPassword = this.config.getHttpAuthUser() + ":" + this.config.getHttpAuthPassword();
        String authorizationHeaderName = "Authorization";
        String authorizationHeaderValue = "Basic " + Base64.getEncoder().encodeToString(usernameAndPassword.getBytes());
        httpClientRequest.putHeader(authorizationHeaderName, authorizationHeaderValue);
    }
}

