/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.handler;

import com.amazonaws.util.StringUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.Optional;
import nl.jpoint.vertx.mod.deploy.handler.RestDeployModuleHandler;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployState;
import nl.jpoint.vertx.mod.deploy.service.AwsService;
import nl.jpoint.vertx.mod.deploy.service.DefaultDeployService;
import nl.jpoint.vertx.mod.deploy.util.ApplicationDeployState;
import nl.jpoint.vertx.mod.deploy.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class RestDeployHandler
implements Handler<RoutingContext> {
    private final DefaultDeployService deployService;
    private final Optional<AwsService> awsService;
    private final String authToken;
    private final Logger LOG = LoggerFactory.getLogger(RestDeployModuleHandler.class);

    public RestDeployHandler(DefaultDeployService deployService, AwsService awsService, String authToken) {
        this.deployService = deployService;
        this.awsService = Optional.ofNullable(awsService);
        this.authToken = authToken;
    }

    public void handle(RoutingContext context) {
        context.request().bodyHandler(buffer -> {
            DeployRequest deployRequest;
            ObjectReader reader = new ObjectMapper().readerFor(DeployRequest.class);
            if (StringUtils.isNullOrEmpty((String)context.request().getHeader("authToken")) || !this.authToken.equals(context.request().getHeader("authToken"))) {
                this.LOG.error("{}: Invalid authToken in request.", (Object)"DeployRequest");
                this.respondFailed(null, context.request(), "Invalid authToken in request.");
                return;
            }
            String eventBody = new String(buffer.getBytes());
            if (eventBody.isEmpty()) {
                this.LOG.error("{}: No POST data in request.", (Object)"DeployRequest");
                this.respondFailed(null, context.request(), "No POST data in request.");
                return;
            }
            this.LOG.debug("{}: received POST data -> {} ", (Object)"DeployRequest", (Object)eventBody);
            try {
                deployRequest = (DeployRequest)reader.readValue(eventBody);
                deployRequest.setTimestamp(System.currentTimeMillis());
            }
            catch (IOException e) {
                this.LOG.error("{}: Error while reading POST data -> {}.", (Object)"DeployRequest", (Object)e.getMessage());
                this.respondFailed(null, context.request(), "Error wile reading post data -> " + e.getMessage());
                return;
            }
            if (deployRequest.withAutoScaling() && !this.awsService.isPresent()) {
                this.LOG.error("Asking for an Aws Enabled deploy. AWS is disabled");
                this.respondFailed(deployRequest.getId().toString(), context.request(), "Aws support disabled");
                return;
            }
            this.LOG.info("[{} - {}]: Received deploy request with {} config(s), {} module(s) and {} artifact(s) ", new Object[]{"DeployRequest", deployRequest.getId().toString(), deployRequest.getConfigs() != null ? deployRequest.getConfigs().size() : 0, deployRequest.getModules() != null ? deployRequest.getModules().size() : 0, deployRequest.getArtifacts() != null ? deployRequest.getArtifacts().size() : 0});
            Observable.just((Object)deployRequest).flatMap(this::registerRequest).flatMap(r -> this.respondContinue((DeployRequest)r, context.request())).flatMap(this::cleanup).flatMap(this::deRegisterInstanceFromAutoScalingGroup).flatMap(this::deRegisterInstanceFromLoadBalancer).flatMap(this::deployConfigs).flatMap(this::deployArtifacts).flatMap(this::stopContainer).flatMap(this::deployApplications).flatMap(this::registerInstanceInAutoScalingGroup).flatMap(this::checkElbStatus).doOnCompleted(() -> this.respond(deployRequest, context.request())).doOnError(t -> this.respondFailed(deployRequest.getId().toString(), context.request(), t.getMessage())).subscribe();
        });
    }

    private Observable<DeployRequest> cleanup(DeployRequest deployRequest) {
        return this.deployService.cleanup(deployRequest);
    }

    private Observable<DeployRequest> deRegisterInstanceFromLoadBalancer(DeployRequest deployRequest) {
        if (deployRequest.withElb() && !deployRequest.withAutoScaling() && this.awsService.isPresent()) {
            return this.awsService.get().loadBalancerDeRegisterInstance(deployRequest);
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> registerRequest(DeployRequest deployRequest) {
        this.awsService.ifPresent(service -> service.registerRequest(deployRequest));
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> respondContinue(DeployRequest deployRequest, HttpServerRequest request) {
        if (deployRequest.withElb()) {
            request.response().setStatusMessage(deployRequest.getId().toString());
            request.response().end(deployRequest.getId().toString());
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> deRegisterInstanceFromAutoScalingGroup(DeployRequest deployRequest) {
        if (deployRequest.withAutoScaling() && this.awsService.isPresent()) {
            return this.awsService.get().autoScalingDeRegisterInstance(deployRequest);
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> deployConfigs(DeployRequest deployRequest) {
        this.awsService.ifPresent(aws -> aws.updateAndGetRequest(DeployState.DEPLOYING_CONFIGS, deployRequest.getId().toString()));
        if (deployRequest.getConfigs() != null && !deployRequest.getConfigs().isEmpty()) {
            return this.deployService.deployConfigs(deployRequest.getId(), deployRequest.getConfigs()).flatMap(list -> {
                if (list.contains(Boolean.TRUE)) {
                    deployRequest.setRestart(true);
                }
                return Observable.just((Object)deployRequest);
            });
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> deployArtifacts(DeployRequest deployRequest) {
        this.awsService.ifPresent(aws -> aws.updateAndGetRequest(DeployState.DEPLOYING_ARTIFACTS, deployRequest.getId().toString()));
        if (deployRequest.getArtifacts() != null && !deployRequest.getArtifacts().isEmpty()) {
            return this.deployService.deployArtifacts(deployRequest.getId(), deployRequest.getArtifacts()).flatMap(x -> Observable.just((Object)deployRequest));
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> stopContainer(DeployRequest deployRequest) {
        this.awsService.ifPresent(aws -> aws.updateAndGetRequest(DeployState.STOPPING_CONTAINER, deployRequest.getId().toString()));
        if (deployRequest.withRestart()) {
            return this.deployService.stopContainer().flatMap(x -> Observable.just((Object)deployRequest));
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> deployApplications(DeployRequest deployRequest) {
        this.awsService.ifPresent(aws -> aws.updateAndGetRequest(DeployState.DEPLOYING_APPLICATIONS, deployRequest.getId().toString()));
        if (deployRequest.getModules() != null && !deployRequest.getModules().isEmpty()) {
            return this.deployService.deployApplications(deployRequest.getId(), deployRequest.getModules()).flatMap(x -> Observable.just((Object)deployRequest));
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> registerInstanceInAutoScalingGroup(DeployRequest deployRequest) {
        if (deployRequest.withAutoScaling() && this.awsService.isPresent()) {
            return this.awsService.get().autoScalingRegisterInstance(deployRequest);
        }
        return Observable.just((Object)deployRequest);
    }

    private Observable<DeployRequest> checkElbStatus(DeployRequest deployRequest) {
        if (deployRequest.withElb() && this.awsService.isPresent()) {
            return this.awsService.get().loadBalancerRegisterInstance(deployRequest);
        }
        return Observable.just((Object)deployRequest);
    }

    private void respond(DeployRequest deployRequest, HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.OK.code());
        this.awsService.ifPresent(aws -> aws.updateAndGetRequest(DeployState.SUCCESS, deployRequest.getId().toString()));
        if (!(request.response().ended() || deployRequest.withElb() || deployRequest.withAutoScaling())) {
            JsonObject result = new JsonObject();
            result.put(ApplicationDeployState.OK.name(), HttpUtils.toArray(this.deployService.getDeployedApplicationsSuccess()));
            result.put(ApplicationDeployState.ERROR.name(), HttpUtils.toArray(this.deployService.getDeployedApplicationsFailed()));
            if (result.isEmpty()) {
                request.response().end();
            } else {
                request.response().end(result.encodePrettily());
            }
        }
    }

    private void respondFailed(String id, HttpServerRequest request, String message) {
        if (!request.response().ended()) {
            request.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            JsonObject result = new JsonObject();
            result.put(ApplicationDeployState.OK.name(), HttpUtils.toArray(this.deployService.getDeployedApplicationsSuccess()));
            result.put(ApplicationDeployState.ERROR.name(), HttpUtils.toArray(this.deployService.getDeployedApplicationsFailed()));
            result.put("message", message);
            if (result.isEmpty()) {
                request.response().end();
            } else {
                request.response().end(result.encodePrettily());
            }
            if (id != null) {
                this.awsService.ifPresent(aws -> aws.failBuild(id));
            }
        }
    }
}

