/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import io.vertx.core.Vertx;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.DeployApplicationRequest;
import nl.jpoint.vertx.mod.deploy.util.ObservableCommand;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class RunApplication
implements Command<DeployApplicationRequest> {
    private static final String JAVA_OPTS = "JAVA_OPTS";
    private static final String INSTANCES = "INSTANCES";
    private static final Logger LOG = LoggerFactory.getLogger(RunApplication.class);
    private final io.vertx.rxjava.core.Vertx rxVertx;
    private final DeployConfig config;

    public RunApplication(Vertx vertx, DeployConfig config) {
        this.rxVertx = new io.vertx.rxjava.core.Vertx(vertx);
        this.config = config;
    }

    @Override
    public Observable<DeployApplicationRequest> executeAsync(DeployApplicationRequest request) {
        LOG.info("[{} - {}]: Running module '{}'", new Object[]{"DeployRequest", request.getId().toString(), request.getModuleId()});
        return this.readServiceDefaults(request).flatMap(this::startApplication).doOnError(t -> LOG.error("[{} - {}]: Error running module '{}', {}", new Object[]{"DeployRequest", request.getId().toString(), request.getModuleId(), t.getMessage()}));
    }

    private Observable<DeployApplicationRequest> readServiceDefaults(DeployApplicationRequest request) {
        Properties serviceProperties = new Properties();
        String path = "/etc/default/" + request.getGroupId() + ":" + request.getArtifactId();
        return this.rxVertx.fileSystem().existsObservable(path).flatMap(exists -> {
            if (exists.booleanValue()) {
                return this.rxVertx.fileSystem().readFileObservable(path).flatMap(buffer -> {
                    try {
                        serviceProperties.load(new ByteArrayInputStream(buffer.toString().getBytes()));
                    }
                    catch (IOException e) {
                        LOG.error("[{} - {}]: Failed to initialize properties for module  {} with error '{}'", new Object[]{"DeployRequest", request.getId(), request.getModuleId(), e.getMessage()});
                    }
                    request.withJavaOpts(serviceProperties.getProperty(JAVA_OPTS));
                    request.withInstances(serviceProperties.getProperty(INSTANCES, "1"));
                    return Observable.just((Object)request);
                });
            }
            return Observable.just((Object)request);
        });
    }

    private Observable<DeployApplicationRequest> startApplication(DeployApplicationRequest deployApplicationRequest) {
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(Arrays.asList(this.config.getVertxHome().resolve("bin/vertx").toString(), "start", "maven:" + deployApplicationRequest.getModuleId(), "-id", deployApplicationRequest.getModuleId()));
        if (this.config.isMavenRemote()) {
            command.add("-Dvertx.maven.remoteRepos=" + this.buildRemoteRepo());
            command.add("-Dvertx.maven.remoteSnapshotPolicy=" + this.config.getRemoteRepoPolicy());
        }
        if (!this.config.getConfigLocation().isEmpty()) {
            command.add("-conf");
            command.add(this.config.getConfigLocation());
        }
        if (!deployApplicationRequest.getJavaOpts().isEmpty() || !this.config.getDefaultJavaOpts().isEmpty()) {
            command.add("--java-opts");
            command.add(deployApplicationRequest.getJavaOpts());
            command.add(this.config.getDefaultJavaOpts());
        }
        command.add("--instances");
        command.add(deployApplicationRequest.getInstances());
        if (this.config.asCluster()) {
            command.add("-cluster");
        }
        command.add("-Dvertxdeploy.port=" + this.config.getHttpPort());
        command.add("-Dvertxdeploy.scope.test=" + deployApplicationRequest.isTestScope());
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(command);
        ObservableCommand<DeployApplicationRequest> observableCommand = new ObservableCommand<DeployApplicationRequest>(deployApplicationRequest, 0, this.rxVertx);
        return observableCommand.execute(processBuilder).flatMap(x -> Observable.just((Object)deployApplicationRequest)).doOnCompleted(() -> LOG.info("[{} - {}]: Started module '{}' with applicationID '{}'", new Object[]{"DeployRequest", deployApplicationRequest.getId(), deployApplicationRequest.getModuleId(), deployApplicationRequest.getMavenArtifactId()})).doOnError(t -> LOG.error("[{} - {}]: Failed to initialize application {} with error '{}'", new Object[]{"DeployRequest", deployApplicationRequest.getId(), deployApplicationRequest.getModuleId(), t}));
    }

    private String buildRemoteRepo() {
        URI remoteRepo = this.config.getNexusUrl();
        if (remoteRepo != null && this.config.isHttpAuthentication()) {
            URIBuilder builder = new URIBuilder(remoteRepo);
            builder.setUserInfo(this.config.getHttpAuthUser() + ":" + this.config.getHttpAuthPassword());
            return builder.toString();
        }
        return this.config.getNexusUrl().toString();
    }
}

