/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import nl.jpoint.vertx.mod.deploy.request.DeployApplicationRequest;
import nl.jpoint.vertx.mod.deploy.util.ExitCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public interface Command<T> {
    public static final Logger LOG = LoggerFactory.getLogger(Command.class);

    public Observable<T> executeAsync(T var1);

    default public Observable<Integer> handleExitCode(DeployApplicationRequest request, Integer exitCode) {
        if (exitCode != 0) {
            LOG.error("[{} -{}]: Error while initializing container {} with error {}", new Object[]{"DeployRequest", request.getId(), request.getModuleId(), ExitCodes.values()[exitCode]});
            throw new IllegalStateException("Error while initializing container " + request.getModuleId() + " with error " + (Object)((Object)ExitCodes.values()[exitCode]));
        }
        return Observable.just((Object)exitCode);
    }
}

