/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import nl.jpoint.vertx.mod.deploy.request.DeployArtifactRequest;
import nl.jpoint.vertx.mod.deploy.service.DeployArtifactService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestDeployArtifactHandler
implements Handler<RoutingContext> {
    private final DeployArtifactService service;
    private final Logger LOG = LoggerFactory.getLogger(RestDeployArtifactHandler.class);

    public RestDeployArtifactHandler(DeployArtifactService service) {
        this.service = service;
    }

    public void handle(RoutingContext context) {
        context.request().bodyHandler(buffer -> {
            DeployArtifactRequest artifactRequest;
            String postData = new String(buffer.getBytes());
            if (postData.isEmpty()) {
                this.LOG.error("{}: No postdata in request.", (Object)"DeployArtifactRequest");
                context.request().response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code());
                context.request().response().end();
                return;
            }
            try {
                artifactRequest = (DeployArtifactRequest)new ObjectMapper().readerFor(DeployArtifactRequest.class).readValue(postData);
            }
            catch (IOException e) {
                this.LOG.error("[{}]: Failed to read postdata {}", (Object)postData);
                this.respondFailed(context.request());
                return;
            }
            this.LOG.info("[{} - {}]: Received deploy artifact request {}", new Object[]{"DeployArtifactRequest", artifactRequest.getId().toString(), postData});
            this.service.deployAsync(artifactRequest).doOnCompleted(() -> this.respondOk(context.request())).doOnError(t -> this.respondFailed(context.request()));
        });
    }

    private void respondOk(HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.OK.code());
        request.response().end();
    }

    private void respondFailed(HttpServerRequest request) {
        request.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        request.response().end();
    }
}

