/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import io.vertx.core.Vertx;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.DeployApplicationRequest;
import nl.jpoint.vertx.mod.deploy.util.ObservableCommand;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class RunApplication
implements Command<DeployApplicationRequest> {
    private static final String JAVA_OPTS = "JAVA_OPTS";
    private static final String INSTANCES = "INSTANCES";
    private static final String MAIN_SERVICE = "MAIN_SERVICE";
    private static final String CONFIG_FILE = "CONFIG_FILE";
    private static final Logger LOG = LoggerFactory.getLogger(RunApplication.class);
    private final io.vertx.rxjava.core.Vertx rxVertx;
    private final DeployConfig deployConfig;

    public RunApplication(Vertx vertx, DeployConfig deployConfig) {
        this.rxVertx = new io.vertx.rxjava.core.Vertx(vertx);
        this.deployConfig = deployConfig;
    }

    @Override
    public Observable<DeployApplicationRequest> executeAsync(DeployApplicationRequest request) {
        LOG.info("[{} - {}]: Running module '{}'", new Object[]{"DeployRequest", request.getId().toString(), request.getModuleId()});
        return this.readServiceDefaults(request).flatMap(this::startApplication).doOnError(t -> LOG.error("[{} - {}]: Error running module '{}', {}", new Object[]{"DeployRequest", request.getId().toString(), request.getModuleId(), t.getMessage()}));
    }

    Observable<DeployApplicationRequest> readServiceDefaults(DeployApplicationRequest request) {
        Properties serviceProperties = new Properties();
        String path = this.deployConfig.getServiceConfigLocation() + request.getGroupId() + ":" + request.getArtifactId();
        return this.rxVertx.fileSystem().existsObservable(path).filter(Boolean.TRUE::equals).map(x -> path).switchIfEmpty(this.rxVertx.fileSystem().existsObservable(path.replace(":", "~")).filter(Boolean.TRUE::equals).map(x -> path.replace(":", "~"))).flatMap(location -> this.rxVertx.fileSystem().readFileObservable(location).flatMap(buffer -> {
            try {
                serviceProperties.load(new ByteArrayInputStream(buffer.toString().getBytes()));
            }
            catch (IOException e) {
                LOG.error("[{} - {}]: Failed to initialize properties for module  {} with error '{}'", new Object[]{"DeployRequest", request.getId(), request.getModuleId(), e.getMessage(), e});
                return Observable.just((Object)request);
            }
            request.withJavaOpts(serviceProperties.getProperty(JAVA_OPTS, ""));
            request.withConfigLocation(serviceProperties.getProperty(CONFIG_FILE, ""));
            request.withInstances(serviceProperties.getProperty(INSTANCES, "1"));
            request.withMainService(serviceProperties.getProperty(MAIN_SERVICE, ""));
            return Observable.just((Object)request);
        }));
    }

    private Observable<DeployApplicationRequest> startApplication(DeployApplicationRequest deployApplicationRequest) {
        String applicationConfig;
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(Arrays.asList(this.deployConfig.getVertxHome().resolve("bin/vertx").toString(), "start", this.getMavenCommand(deployApplicationRequest), "-id", deployApplicationRequest.getModuleId()));
        if (this.deployConfig.isMavenRemote()) {
            command.add("-Dvertx.maven.remoteRepos=" + this.buildRemoteRepo());
            command.add("-Dvertx.maven.remoteSnapshotPolicy=" + this.deployConfig.getRemoteRepoPolicy());
        }
        String string = applicationConfig = deployApplicationRequest.getConfigLocation().isEmpty() ? this.deployConfig.getConfigLocation() : deployApplicationRequest.getConfigLocation();
        if (!applicationConfig.isEmpty()) {
            command.add("-conf");
            command.add(applicationConfig);
        }
        if (!deployApplicationRequest.getJavaOpts().isEmpty() || !this.deployConfig.getDefaultJavaOpts().isEmpty()) {
            command.add("--java-opts");
            command.add(deployApplicationRequest.getJavaOpts());
            command.add(this.deployConfig.getDefaultJavaOpts());
        }
        command.add("--instances");
        command.add(deployApplicationRequest.getInstances());
        if (this.deployConfig.asCluster()) {
            command.add("-cluster");
        }
        command.add("-Dvertxdeploy.port=" + this.deployConfig.getHttpPort());
        command.add("-Dvertxdeploy.scope.test=" + deployApplicationRequest.isTestScope());
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(command);
        ObservableCommand<DeployApplicationRequest> observableCommand = new ObservableCommand<DeployApplicationRequest>(deployApplicationRequest, 0, this.rxVertx, false);
        return observableCommand.execute(processBuilder).flatMap(exitCode -> this.handleExitCode(deployApplicationRequest, (Integer)exitCode)).flatMap(x -> Observable.just((Object)deployApplicationRequest)).doOnCompleted(() -> LOG.info("[{} - {}]: Started module '{}' with applicationID '{}'", new Object[]{"DeployRequest", deployApplicationRequest.getId(), deployApplicationRequest.getModuleId(), deployApplicationRequest.getMavenArtifactId()})).doOnError(t -> LOG.error("[{} - {}]: Failed to initialize application {} with error '{}'", new Object[]{"DeployRequest", deployApplicationRequest.getId(), deployApplicationRequest.getModuleId(), t}));
    }

    String getMavenCommand(DeployApplicationRequest request) {
        if (!StringUtils.isBlank((CharSequence)request.getMainService())) {
            return String.format("maven:%s::%s", request.getModuleId(), request.getMainService());
        }
        return String.format("maven:%s", request.getModuleId());
    }

    private String buildRemoteRepo() {
        URI remoteRepo = this.deployConfig.getNexusUrl();
        if (remoteRepo != null && this.deployConfig.isHttpAuthentication()) {
            URIBuilder builder = new URIBuilder(remoteRepo);
            builder.setUserInfo(this.deployConfig.getHttpAuthUser() + ":" + this.deployConfig.getHttpAuthPassword());
            return builder.toString();
        }
        return this.deployConfig.getNexusUrl().toString();
    }
}

