/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Vertx;
import java.net.URI;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import nl.jpoint.vertx.mod.deploy.util.RxHttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class DownloadArtifact<T extends ModuleRequest>
implements Command<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadArtifact.class);
    private final DeployConfig config;
    private final io.vertx.rxjava.core.Vertx rxVertx;

    public DownloadArtifact(DeployConfig config, Vertx vertx) {
        this.config = config;
        this.rxVertx = new io.vertx.rxjava.core.Vertx(vertx);
    }

    @Override
    public Observable<T> executeAsync(T request) {
        URI location = this.config.getNexusUrl().resolve(this.config.getNexusUrl().getPath() + "/" + ((ModuleRequest)request).getRemoteLocation());
        return new RxHttpUtil(this.rxVertx, this.config).get(((ModuleRequest)request).getId(), location, this.config.getArtifactRepo() + "/" + ((ModuleRequest)request).getFileName()).flatMap(x -> {
            if (x.statusCode() != HttpResponseStatus.OK.code()) {
                LOG.error("[{} - {}]: Error downloading artifact {} for url {}.", new Object[]{"DeployArtifactRequest", request.getId(), request.getModuleId(), location});
                LOG.error("[{} - {}]: HttpClient Error [{}] -> {}.", new Object[]{"DeployArtifactRequest", request.getId(), x.statusCode(), x.statusMessage()});
                throw new IllegalStateException();
            }
            LOG.info("[{} - {}]: Downloaded artifact {} to {}.", new Object[]{"DeployArtifactRequest", request.getId(), request.getModuleId(), this.config.getArtifactRepo() + request.getModuleId() + "." + request.getType()});
            return Observable.just((Object)request);
        }).flatMap(x -> Observable.just((Object)request)).doOnError(t -> LOG.error("[{} - {}]: Error downloading artifact -> {}, {}", new Object[]{"DeployArtifactRequest", request.getId(), t.getMessage(), t}));
    }
}

