/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.service;

import io.vertx.core.Vertx;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.RunConsoleCommand;
import nl.jpoint.vertx.mod.deploy.request.DeployConfigRequest;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import nl.jpoint.vertx.mod.deploy.service.DeployService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class DeployConfigService
implements DeployService<DeployConfigRequest, Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(DeployConfigService.class);
    private final Vertx vertx;
    private final DeployConfig config;

    public DeployConfigService(Vertx vertx, DeployConfig config) {
        this.vertx = vertx;
        this.config = config;
    }

    @Override
    public Observable<Boolean> deployAsync(DeployConfigRequest deployRequest) {
        return this.resolveSnapShotVersion(deployRequest).flatMap(this::downloadArtifact).flatMap(this::parseArtifactContext).flatMap(this::extractArtifact).flatMap(this::runTestCommand).flatMap(this::runRestartCommand).map(ModuleRequest::restart).doOnCompleted(() -> LOG.info("[{} - {}]: Done extracting config {}.", new Object[]{deployRequest.getLogName(), deployRequest.getId(), deployRequest.getModuleId()})).doOnError(t -> LOG.error("[{} - {}]: Error extracting config {} : {}.", new Object[]{deployRequest.getLogName(), deployRequest.getId(), deployRequest.getModuleId(), t}));
    }

    @Override
    public DeployConfig getConfig() {
        return this.config;
    }

    @Override
    public Vertx getVertx() {
        return this.vertx;
    }

    private Observable<DeployConfigRequest> runTestCommand(DeployConfigRequest deployConfigRequest) {
        if (deployConfigRequest.getTestCommand().isPresent()) {
            RunConsoleCommand consoleCommand = new RunConsoleCommand(this.vertx, deployConfigRequest.getTestCommand().get());
            return consoleCommand.executeAsync(deployConfigRequest);
        }
        return Observable.just((Object)deployConfigRequest);
    }

    private Observable<DeployConfigRequest> runRestartCommand(DeployConfigRequest deployConfigRequest) {
        if (deployConfigRequest.getRestartCommand().isPresent()) {
            RunConsoleCommand consoleCommand = new RunConsoleCommand(this.vertx, deployConfigRequest.getRestartCommand().get());
            return consoleCommand.executeAsync(deployConfigRequest);
        }
        return Observable.just((Object)deployConfigRequest);
    }
}

