/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import io.vertx.core.Vertx;
import io.vertx.rxjava.core.buffer.Buffer;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import nl.jpoint.vertx.mod.deploy.util.MetadataXPathUtil;
import nl.jpoint.vertx.mod.deploy.util.RxHttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class ResolveSnapshotVersion<T extends ModuleRequest>
implements Command<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ResolveSnapshotVersion.class);
    private final DeployConfig config;
    private final io.vertx.rxjava.core.Vertx rxVertx;

    public ResolveSnapshotVersion(DeployConfig config, Vertx vertx) {
        this.rxVertx = new io.vertx.rxjava.core.Vertx(vertx);
        this.config = config;
    }

    @Override
    public Observable<T> executeAsync(T request) {
        URI location = this.config.getNexusUrl().resolve(this.config.getNexusUrl().getPath() + "/" + ((ModuleRequest)request).getMetadataLocation());
        Path filename = this.createTempFile(((ModuleRequest)request).getArtifactId());
        return new RxHttpUtil(this.rxVertx, this.config).get(((ModuleRequest)request).getId(), location, filename).flatMap(x -> {
            request.setVersion(this.retrieveAndParseMetadata(filename, (ModuleRequest)request));
            return Observable.just((Object)request);
        }).onErrorReturn(x -> {
            LOG.error("[{} - {}]: Error downloading artifact {} for url {} -> .", new Object[]{"DeployArtifactRequest", request.getId(), request.getModuleId(), location, x});
            return request;
        });
    }

    private Path createTempFile(String filename) {
        return Paths.get(System.getProperty("java.io.tmpdir") + "/" + filename, new String[0]);
    }

    private String retrieveAndParseMetadata(Path fileLocation, ModuleRequest request) {
        Buffer b = this.rxVertx.fileSystem().readFileBlocking(fileLocation.toString());
        return MetadataXPathUtil.getRealSnapshotVersionFromMetadata(b.toString().getBytes(), request);
    }
}

