/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingAsyncClient;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import com.amazonaws.services.elasticloadbalancing.model.InstanceState;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import com.amazonaws.util.EC2MetadataUtils;
import java.util.Optional;
import java.util.concurrent.Future;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.aws.AwsException;
import nl.jpoint.vertx.mod.deploy.aws.AwsState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class AwsElbUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AwsElbUtil.class);
    private final AmazonElasticLoadBalancingAsyncClient elbAsyncClient = new AmazonElasticLoadBalancingAsyncClient();
    private final String instanceId;

    public AwsElbUtil(DeployConfig config) {
        this.elbAsyncClient.setRegion(Region.getRegion((Regions)Regions.fromName((String)config.getAwsRegion())));
        this.instanceId = EC2MetadataUtils.getInstanceId();
    }

    public Observable<String> registerInstanceWithLoadBalancer(String loadBalancer) {
        if (this.instanceId == null || loadBalancer == null) {
            LOG.error("Unable to register instance {}, on load balancer {}.", (Object)this.instanceId, (Object)loadBalancer);
            throw new IllegalStateException();
        }
        try {
            return Observable.from((Future)this.elbAsyncClient.registerInstancesWithLoadBalancerAsync(new RegisterInstancesWithLoadBalancerRequest().withLoadBalancerName(loadBalancer).withInstances(new Instance[]{new Instance().withInstanceId(this.instanceId)}))).flatMap(x -> Observable.just((Object)loadBalancer)).doOnError(t -> LOG.error("Error executing request {}.", t));
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            throw new AwsException(e);
        }
    }

    public Observable<String> deRegisterInstanceFromLoadbalancer(String loadBalancer) {
        if (this.instanceId == null || loadBalancer == null) {
            LOG.error("Unable to register instance {}, on load balancer {}.", (Object)this.instanceId, (Object)loadBalancer);
            throw new IllegalStateException();
        }
        try {
            return Observable.from((Future)this.elbAsyncClient.deregisterInstancesFromLoadBalancerAsync(new DeregisterInstancesFromLoadBalancerRequest().withLoadBalancerName(loadBalancer).withInstances(new Instance[]{new Instance().withInstanceId(this.instanceId)}))).flatMap(x -> Observable.just((Object)loadBalancer));
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            throw new AwsException(e);
        }
    }

    public Observable<AwsState> pollForInstanceState(String loadBalancer) {
        try {
            return Observable.from((Future)this.elbAsyncClient.describeInstanceHealthAsync(new DescribeInstanceHealthRequest().withLoadBalancerName(loadBalancer).withInstances(new Instance[]{new Instance().withInstanceId(this.instanceId)}))).flatMap(result -> {
                Optional<InstanceState> state = result.getInstanceStates().stream().filter(i -> i.getInstanceId().equals(this.instanceId)).findFirst();
                return Observable.just((Object)((Object)(state.isPresent() ? AwsState.map(state.get().getState()) : AwsState.UNKNOWN)));
            });
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            throw new AwsException(e);
        }
    }

    public String getInstanceId() {
        return this.instanceId;
    }
}

