/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.service;

import io.vertx.core.Vertx;
import io.vertx.rxjava.core.file.FileSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.RunApplication;
import nl.jpoint.vertx.mod.deploy.command.StopApplication;
import nl.jpoint.vertx.mod.deploy.request.DeployApplicationRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import nl.jpoint.vertx.mod.deploy.service.DeployService;
import nl.jpoint.vertx.mod.deploy.util.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class DeployApplicationService
implements DeployService<DeployApplicationRequest, DeployApplicationRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(DeployApplicationService.class);
    private final DeployConfig config;
    private final Vertx vertx;
    private final List<String> deployedApplicationsSuccess = new ArrayList<String>();
    private final Map<String, Object> deployedApplicationsFailed = new HashMap<String, Object>();

    public DeployApplicationService(DeployConfig config, Vertx vertx) {
        this.config = config;
        this.vertx = vertx;
    }

    @Override
    public Observable<DeployApplicationRequest> deployAsync(DeployApplicationRequest deployApplicationRequest) {
        return this.resolveSnapShotVersion(deployApplicationRequest).flatMap(this::checkModuleState).flatMap(this::stopApplication).flatMap(this::startApplication).flatMap(this::registerApplication);
    }

    private Observable<DeployApplicationRequest> checkModuleState(DeployApplicationRequest deployApplicationRequest) {
        new ProcessUtils(this.config).checkModuleRunning(deployApplicationRequest);
        LOG.info("[{} - {}]: Module '{}' running : {}, sameVersion : {}.", new Object[]{"DeployRequest", deployApplicationRequest.getId(), deployApplicationRequest.getModuleId(), deployApplicationRequest.isInstalled(), deployApplicationRequest.isInstalled()});
        return Observable.just((Object)deployApplicationRequest);
    }

    private Observable<DeployApplicationRequest> stopApplication(DeployApplicationRequest deployApplicationRequest) {
        if (deployApplicationRequest.isRunning() && !deployApplicationRequest.isInstalled()) {
            StopApplication stopApplicationCommand = new StopApplication(this.vertx, this.config);
            return stopApplicationCommand.executeAsync(deployApplicationRequest);
        }
        return Observable.just((Object)deployApplicationRequest);
    }

    private Observable<DeployApplicationRequest> startApplication(DeployApplicationRequest deployApplicationRequest) {
        if (!deployApplicationRequest.isRunning()) {
            RunApplication runModCommand = new RunApplication(this.vertx, this.config);
            return runModCommand.executeAsync(deployApplicationRequest);
        }
        return Observable.just((Object)deployApplicationRequest);
    }

    private Observable<DeployApplicationRequest> registerApplication(DeployApplicationRequest deployApplicationRequest) {
        io.vertx.rxjava.core.Vertx rxVertx = new io.vertx.rxjava.core.Vertx(this.vertx);
        return rxVertx.fileSystem().existsObservable(this.config.getRunDir() + deployApplicationRequest.getModuleId()).flatMap(exists -> {
            if (!exists.booleanValue()) {
                return rxVertx.fileSystem().createFileObservable(this.config.getRunDir() + deployApplicationRequest.getModuleId()).flatMap(x -> Observable.just((Object)deployApplicationRequest));
            }
            return Observable.just((Object)deployApplicationRequest);
        });
    }

    @Override
    public DeployConfig getConfig() {
        return this.config;
    }

    @Override
    public Vertx getVertx() {
        return this.vertx;
    }

    Observable<Boolean> stopContainer() {
        LOG.info("[{}]: Stopping all running modules", (Object)"InvokeContainer");
        return Observable.from(new ProcessUtils(this.config).listInstalledAndRunningModules().entrySet()).flatMap(entry -> {
            StopApplication stopApplication = new StopApplication(this.vertx, this.config);
            String[] mavenIds = ((String)entry.getKey()).split(":", 2);
            DeployApplicationRequest request = new DeployApplicationRequest(mavenIds[0], mavenIds[1], (String)entry.getValue(), null, "jar");
            request.setRunning(false);
            request.setInstalled(false);
            return stopApplication.executeAsync(request);
        }).toList().flatMap(x -> Observable.just((Object)true));
    }

    Observable<DeployRequest> cleanup(DeployRequest deployRequest) {
        this.deployedApplicationsSuccess.clear();
        this.deployedApplicationsFailed.clear();
        return this.cleanup().flatMap(x -> Observable.just((Object)deployRequest));
    }

    public Observable<Boolean> cleanup() {
        List<String> runningApplications = new ProcessUtils(this.config).listModules();
        FileSystem fs = new io.vertx.rxjava.core.Vertx(this.vertx).fileSystem();
        return fs.readDirObservable(this.config.getRunDir()).flatMapIterable(x -> x).flatMap(s -> Observable.just((Object)Pattern.compile("/").splitAsStream((CharSequence)s).reduce((a, b) -> b).orElse(""))).filter(s -> !s.isEmpty() && !runningApplications.contains(s)).flatMap(file -> fs.deleteObservable(this.config.getRunDir() + file)).toList().flatMap(x -> Observable.just((Object)Boolean.TRUE).doOnError(t -> LOG.error("error"))).onErrorReturn(x -> {
            LOG.error("Error during cleanup of run files {}", (Object)x.getMessage());
            return Boolean.FALSE;
        });
    }

    public void addApplicationDeployResult(boolean succeeded, String message, String deploymentId) {
        if (succeeded && !this.deployedApplicationsSuccess.contains(deploymentId)) {
            this.deployedApplicationsSuccess.add(deploymentId);
        }
        if (!succeeded && !this.deployedApplicationsFailed.containsKey(deploymentId)) {
            this.deployedApplicationsFailed.put(deploymentId, message != null ? message : "No reason provided by application.");
        }
    }

    public List<String> getDeployedApplicationsSuccess() {
        return this.deployedApplicationsSuccess;
    }

    public Map<String, Object> getDeployedApplicationsFailed() {
        return this.deployedApplicationsFailed;
    }
}

