/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.autoscaling.AmazonAutoScalingAsyncClient;
import com.amazonaws.services.autoscaling.model.AmazonAutoScalingException;
import com.amazonaws.services.autoscaling.model.AutoScalingInstanceDetails;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesResult;
import com.amazonaws.services.autoscaling.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.autoscaling.model.DescribeTagsRequest;
import com.amazonaws.services.autoscaling.model.DescribeTagsResult;
import com.amazonaws.services.autoscaling.model.EnterStandbyRequest;
import com.amazonaws.services.autoscaling.model.ExitStandbyRequest;
import com.amazonaws.services.autoscaling.model.Filter;
import com.amazonaws.services.autoscaling.model.LoadBalancerState;
import com.amazonaws.util.EC2MetadataUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.aws.AwsException;
import nl.jpoint.vertx.mod.deploy.aws.AwsState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class AwsAutoScalingUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AwsAutoScalingUtil.class);
    private final AmazonAutoScalingAsyncClient asyncClient = new AmazonAutoScalingAsyncClient();
    public static final String LATEST_VERSION_TAG = "deploy:latest:version";
    public static final String SCOPE_TAG = "deploy:scope:tst";
    public static final String EXCLUSION_TAG = "deploy:exclusions";
    public static final String PROPERTIES_TAGS = "deploy:classifier:properties";
    private final String instanceId;

    public AwsAutoScalingUtil(DeployConfig config) {
        this.asyncClient.setRegion(Region.getRegion((Regions)Regions.fromName((String)config.getAwsRegion())));
        this.instanceId = EC2MetadataUtils.getInstanceId();
    }

    public Optional<AutoScalingInstanceDetails> describeInstance() {
        try {
            DescribeAutoScalingInstancesResult result = this.asyncClient.describeAutoScalingInstances(new DescribeAutoScalingInstancesRequest().withInstanceIds(Collections.singletonList(this.instanceId)));
            return result.getAutoScalingInstances().stream().filter(a -> a.getInstanceId().equals(this.instanceId)).findFirst();
        }
        catch (AmazonAutoScalingException e) {
            if (e.getStatusCode() == 403) {
                LOG.error("Looks like the instance role is not correctly authorized, please see : https://github.com/msoute/vertx-deploy-tools#aws-iam-policy");
            }
            LOG.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public Observable<AwsState> pollForInstanceState() {
        try {
            return Observable.from((Future)this.asyncClient.describeAutoScalingInstancesAsync(new DescribeAutoScalingInstancesRequest().withInstanceIds(new String[]{this.instanceId}))).flatMap(result -> {
                Optional<String> optState = result.getAutoScalingInstances().stream().filter(i -> i.getInstanceId().equals(this.instanceId)).map(AutoScalingInstanceDetails::getLifecycleState).findFirst();
                return Observable.just((Object)((Object)(optState.isPresent() ? AwsState.map(optState.get()) : AwsState.UNKNOWN)));
            });
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            throw new AwsException(e);
        }
    }

    public Observable<String> listLoadBalancers(String groupId) {
        try {
            return Observable.from((Future)this.asyncClient.describeLoadBalancersAsync(new DescribeLoadBalancersRequest().withAutoScalingGroupName(groupId))).map(result -> result.getLoadBalancers().stream().map(LoadBalancerState::getLoadBalancerName).collect(Collectors.toList())).flatMap(Observable::from);
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            throw new AwsException(e);
        }
    }

    public boolean enterStandby(String groupId, boolean decrementDesiredCapacity) {
        try {
            DescribeAutoScalingInstancesResult result = this.asyncClient.describeAutoScalingInstances(new DescribeAutoScalingInstancesRequest().withMaxRecords(Integer.valueOf(1)).withInstanceIds(new String[]{this.instanceId}));
            Optional<AutoScalingInstanceDetails> state = result.getAutoScalingInstances().stream().filter(asi -> asi.getInstanceId().equals(this.instanceId)).findFirst();
            state.ifPresent(s -> LOG.trace("enterStandby() instance {} current state : {}", (Object)this.instanceId, (Object)s.getLifecycleState()));
            if (state.isPresent() && state.get().getLifecycleState().equalsIgnoreCase(AwsState.STANDBY.name())) {
                return true;
            }
            this.asyncClient.enterStandby(new EnterStandbyRequest().withAutoScalingGroupName(groupId).withInstanceIds(new String[]{this.instanceId}).withShouldDecrementDesiredCapacity(Boolean.valueOf(decrementDesiredCapacity)));
            return true;
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            return false;
        }
    }

    public boolean exitStandby(String groupId) {
        try {
            this.asyncClient.exitStandby(new ExitStandbyRequest().withAutoScalingGroupName(groupId).withInstanceIds(new String[]{this.instanceId}));
            return true;
        }
        catch (AmazonClientException e) {
            LOG.error("Error executing request {}.", (Throwable)e);
            return false;
        }
    }

    public Map<String, String> getDeployTags() {
        HashMap<String, String> tags = new HashMap<String, String>(3);
        Optional<AutoScalingInstanceDetails> details = this.describeInstance();
        if (details.isPresent()) {
            details.get().getAutoScalingGroupName();
            List<Filter> filters = Collections.singletonList(new Filter().withName("auto-scaling-group").withValues(new String[]{details.get().getAutoScalingGroupName()}));
            DescribeTagsResult result = this.asyncClient.describeTags(new DescribeTagsRequest().withFilters(filters));
            result.getTags().forEach(t -> tags.put(t.getKey(), t.getValue()));
        }
        return tags;
    }

    public String getInstanceId() {
        return this.instanceId;
    }
}

