/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.service;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import nl.jpoint.vertx.mod.deploy.request.DeployApplicationRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployArtifactRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployConfigRequest;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import nl.jpoint.vertx.mod.deploy.service.DeployApplicationService;
import nl.jpoint.vertx.mod.deploy.service.DeployArtifactService;
import nl.jpoint.vertx.mod.deploy.service.DeployConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class DefaultDeployService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDeployService.class);
    private final DeployApplicationService applicationDeployService;
    private final DeployArtifactService artifactDeployService;
    private final DeployConfigService configDeployService;

    public DefaultDeployService(DeployApplicationService deployApplicationService, DeployArtifactService artifactDeployService, DeployConfigService configDeployService) {
        this.applicationDeployService = deployApplicationService;
        this.artifactDeployService = artifactDeployService;
        this.configDeployService = configDeployService;
    }

    public Observable<List<Boolean>> deployConfigs(UUID id, List<DeployConfigRequest> configs) {
        return Observable.from(configs).flatMap(this.configDeployService::deployAsync).toList().flatMap(x -> {
            LOG.info("[{} - {}]: Done extracting all config.", (Object)"DeployConfigRequest", (Object)id);
            return Observable.just((Object)x);
        });
    }

    public Observable<List<DeployArtifactRequest>> deployArtifacts(UUID id, List<DeployArtifactRequest> artifacts) {
        return Observable.from(artifacts).flatMap(this.artifactDeployService::deployAsync).toList().flatMap(x -> {
            LOG.info("[{} - {}]: Done extracting all artifacts.", (Object)"DeployArtifactRequest", (Object)id);
            return Observable.just((Object)x);
        });
    }

    public Observable<List<DeployApplicationRequest>> deployApplications(UUID id, List<DeployApplicationRequest> applications) {
        return Observable.from(applications).flatMap(this.applicationDeployService::deployAsync).toList().flatMap(x -> {
            LOG.info("[{} - {}]: Done extracting all applications.", (Object)"DeployRequest", (Object)id);
            return Observable.just((Object)x);
        });
    }

    public Observable<DeployRequest> cleanup(DeployRequest deployRequest) {
        return this.applicationDeployService.cleanup(deployRequest);
    }

    public Observable<Boolean> stopContainer() {
        return this.applicationDeployService.stopContainer();
    }

    public List<String> getDeployedApplicationsSuccess() {
        return this.applicationDeployService.getDeployedApplicationsSuccess();
    }

    public Map<String, Object> getDeployedApplicationsFailed() {
        return this.applicationDeployService.getDeployedApplicationsFailed();
    }
}

