/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.aws.state;

import io.vertx.core.Vertx;
import java.time.LocalDateTime;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.aws.AwsAutoScalingUtil;
import nl.jpoint.vertx.mod.deploy.aws.AwsState;
import nl.jpoint.vertx.mod.deploy.aws.state.AwsPollingAsStateObservable;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.DeployRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class AwsAsDeRegisterInstance
implements Command<DeployRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(AwsAsDeRegisterInstance.class);
    private final AwsAutoScalingUtil awsAsUtil;
    private final AwsPollingAsStateObservable poller;

    public AwsAsDeRegisterInstance(Vertx vertx, DeployConfig config, Integer maxDuration) {
        this.awsAsUtil = new AwsAutoScalingUtil(config);
        this.poller = new AwsPollingAsStateObservable(vertx, this.awsAsUtil, LocalDateTime.now().plusMinutes(maxDuration.intValue()), AwsState.STANDBY, AwsState.OUTOFSERVICE, AwsState.NOTREGISTERED);
    }

    @Override
    public Observable<DeployRequest> executeAsync(DeployRequest request) {
        if (!this.awsAsUtil.enterStandby(request.getAutoScalingGroup(), request.isDecrementDesiredCapacity())) {
            LOG.info("[{} - {}]: Failed to enter standby for Instance {} in auto scaling group {}.", new Object[]{"ConfigureAwsAutoScaling", request.getId(), this.awsAsUtil.getInstanceId(), request.getAutoScalingGroup()});
            throw new IllegalStateException();
        }
        LOG.info("[{} - {}]: Waiting for instance {} status in auto scaling group {} to reach {}.", new Object[]{"ConfigureAwsAutoScaling", request.getId(), this.awsAsUtil.getInstanceId(), request.getAutoScalingGroup(), AwsState.STANDBY});
        LOG.info("[{} - {}]: Starting instance status poller for instance id {} in auto scaling group {}", new Object[]{"ConfigureAwsAutoScaling", request.getId(), this.awsAsUtil.getInstanceId(), request.getAutoScalingGroup()});
        return this.poller.poll(request);
    }
}

