/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.ModuleRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class DownloadHttpArtifact<T extends ModuleRequest>
implements Command<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadHttpArtifact.class);
    private final DeployConfig config;

    public DownloadHttpArtifact(DeployConfig config) {
        this.config = config;
    }

    @Override
    public Observable<T> executeAsync(T request) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.config.getHttpAuthUser(), this.config.getHttpAuthPassword());
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        URI location = this.config.getNexusUrl().resolve(this.config.getNexusUrl().getPath() + "/" + ((ModuleRequest)request).getRemoteLocation());
        try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();){
            LOG.info("[{} - {}]: Downloaded artifact {} to {}.", new Object[]{"DeployArtifactRequest", ((ModuleRequest)request).getId(), ((ModuleRequest)request).getModuleId(), ((ModuleRequest)request).getLocalPath(this.config.getArtifactRepo())});
            HttpGet get = new HttpGet(location);
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            response.getEntity().writeTo((OutputStream)new FileOutputStream(((ModuleRequest)request).getLocalPath(this.config.getArtifactRepo()).toFile()));
        }
        catch (IOException e) {
            LOG.error("[{} - {}]: Error downloading artifact -> {}, {}", new Object[]{"DeployArtifactRequest", ((ModuleRequest)request).getId(), e.getMessage(), e});
            throw new IllegalStateException(e);
        }
        return Observable.just(request);
    }
}

