/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDigestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileDigestUtil.class);
    private MessageDigest md;

    public FileDigestUtil() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Error creating MD instance", (Throwable)e);
            this.md = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getFileMd5Sum(Path unpackFile) {
        if (this.md == null || Files.notExists(unpackFile, new LinkOption[0])) {
            LOG.debug("MD is null {}, or file does not exist {}", (Object)this.md, (Object)unpackFile);
            return null;
        }
        try (InputStream is = Files.newInputStream(unpackFile, new OpenOption[0]);){
            DigestInputStream dis = new DigestInputStream(is, this.md);
            while (dis.read() != -1) {
            }
            byte[] digest = this.md.digest();
            this.md.reset();
            byte[] byArray = digest;
            return byArray;
        }
        catch (IOException e) {
            LOG.error("Error calculating MD5 sum", (Throwable)e);
            return null;
        }
    }
}

