/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.handler;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import nl.jpoint.vertx.mod.deploy.request.DeployApplicationRequest;
import nl.jpoint.vertx.mod.deploy.service.DeployApplicationService;
import nl.jpoint.vertx.mod.deploy.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestDeployModuleHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = LoggerFactory.getLogger(RestDeployModuleHandler.class);
    private final DeployApplicationService service;

    public RestDeployModuleHandler(DeployApplicationService service) {
        this.service = service;
    }

    public void handle(RoutingContext context) {
        context.request().bodyHandler(buffer -> {
            DeployApplicationRequest deployRequest = HttpUtils.readPostData(buffer, DeployApplicationRequest.class, "DeployRequest");
            if (deployRequest == null) {
                HttpUtils.respondBadRequest(context.request());
                return;
            }
            LOG.info("[{} - {}]: Received deploy module {}", new Object[]{"DeployRequest", deployRequest.getId().toString(), deployRequest.toString()});
            this.service.deployAsync(deployRequest).doOnCompleted(() -> HttpUtils.respondOk(context.request())).doOnError(t -> HttpUtils.respondFailed(context.request()));
        });
    }
}

