/*
 * Decompiled with CFR 0.152.
 */
package nl.jpoint.vertx.mod.deploy.command;

import io.vertx.core.Vertx;
import java.time.LocalDateTime;
import java.util.Arrays;
import nl.jpoint.vertx.mod.deploy.DeployConfig;
import nl.jpoint.vertx.mod.deploy.command.Command;
import nl.jpoint.vertx.mod.deploy.request.DeployApplicationRequest;
import nl.jpoint.vertx.mod.deploy.util.ObservableCommand;
import nl.jpoint.vertx.mod.deploy.util.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class StopApplication
implements Command<DeployApplicationRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(StopApplication.class);
    private static final Long POLLING_INTERVAL_IN_MS = 500L;
    private final LocalDateTime timeout;
    private final LocalDateTime waitTimeout = LocalDateTime.now().plusSeconds(10L);
    private final DeployConfig config;
    private final ProcessUtils processUtils;
    private final io.vertx.rxjava.core.Vertx rxVertx;
    private boolean killed = false;
    private String moduleIdToStop;

    public StopApplication(Vertx vertx, DeployConfig config) {
        this.config = config;
        this.processUtils = new ProcessUtils(config);
        this.rxVertx = new io.vertx.rxjava.core.Vertx(vertx);
        this.timeout = LocalDateTime.now().plusMinutes(config.getAwsMaxRegistrationDuration());
    }

    @Override
    public Observable<DeployApplicationRequest> executeAsync(DeployApplicationRequest request) {
        LOG.info("[{} - {}]: Waiting for module {} to stop.", new Object[]{"DeployRequest", request.getId(), request.getMavenArtifactId()});
        return this.stopApplication(request).flatMap(this::doPoll).flatMap(this::removeRunFile);
    }

    private Observable<DeployApplicationRequest> removeRunFile(DeployApplicationRequest deployApplicationRequest) {
        deployApplicationRequest.setRunning(false);
        return this.rxVertx.fileSystem().existsObservable(this.config.getRunDir() + this.moduleIdToStop).flatMap(exists -> {
            if (exists.booleanValue()) {
                LOG.info("[{} - {}]: Removing runfile for application with applicationId '{}'.", new Object[]{"DeployRequest", deployApplicationRequest.getId(), this.moduleIdToStop});
                return this.rxVertx.fileSystem().deleteObservable(this.config.getRunDir() + this.moduleIdToStop).flatMap(x -> Observable.just((Object)deployApplicationRequest));
            }
            return Observable.just((Object)deployApplicationRequest);
        });
    }

    private Observable<DeployApplicationRequest> stopApplication(DeployApplicationRequest request) {
        this.moduleIdToStop = request.getMavenArtifactId() + ":" + new ProcessUtils(this.config).getRunningVersion(request);
        LOG.info("[{} - {}]: Stopping application with applicationId '{}'.", new Object[]{"DeployRequest", request.getId(), this.moduleIdToStop});
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(Arrays.asList(this.config.getVertxHome().resolve("bin/vertx").toString(), "stop", this.moduleIdToStop));
        ObservableCommand<DeployApplicationRequest> observableCommand = new ObservableCommand<DeployApplicationRequest>(request, 0, this.rxVertx);
        return observableCommand.execute(processBuilder).flatMap(exitCode -> this.handleExitCode(request, (Integer)exitCode)).flatMap(x -> Observable.just((Object)request)).doOnError(t -> LOG.error("[{} - {}]: Failed to stop module {}", new Object[]{"DeployRequest", request.getId(), request.getModuleId()}));
    }

    private Observable<DeployApplicationRequest> doPoll(DeployApplicationRequest request) {
        return this.rxVertx.timerStream(POLLING_INTERVAL_IN_MS.longValue()).toObservable().flatMap(x -> this.processUtils.checkModuleRunning(request)).flatMap(result -> {
            if (LocalDateTime.now().isAfter(this.timeout)) {
                LOG.error("[{} - {}]: Timeout while waiting for application to stop. ", (Object)"DeployRequest", (Object)request.getId());
                throw new IllegalStateException();
            }
            if (!request.isRunning()) {
                LOG.info("[{} - {}]: Application {} stopped.", new Object[]{"DeployRequest", request.getId(), request.getMavenArtifactId()});
                return Observable.just((Object)request);
            }
            if (LocalDateTime.now().isAfter(this.waitTimeout) && !this.killed) {
                LOG.info("[{} - {}]: Application {} killed.", new Object[]{"DeployRequest", request.getId(), request.getMavenArtifactId()});
                this.killed = ProcessUtils.killService(request.getMavenArtifactId());
                return this.doPoll(request);
            }
            LOG.trace("[{} - {}]: Application {} still running.", new Object[]{"DeployRequest", request.getId(), request.getMavenArtifactId()});
            return this.doPoll(request);
        }).doOnError(t -> LOG.info("[{} - {}]: Error while Waiting for  module '{}' with applicationId '{}' to stop -> '{}'.", new Object[]{"DeployRequest", request.getId(), request.getModuleId(), t}));
    }
}

