/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.conformance.profile;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import gov.loc.repository.bagit.conformance.profile.BagInfoRequirement;
import gov.loc.repository.bagit.conformance.profile.BagitProfile;
import gov.loc.repository.bagit.conformance.profile.Serialization;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BagitProfileDeserializer
extends StdDeserializer<BagitProfile> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(BagitProfileDeserializer.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");

    public BagitProfileDeserializer() {
        this(null);
    }

    public BagitProfileDeserializer(Class<?> vc) {
        super(vc);
    }

    public BagitProfile deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        BagitProfile profile = new BagitProfile();
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        BagitProfileDeserializer.parseBagitProfileInfo(node, profile);
        profile.setBagInfoRequirements(BagitProfileDeserializer.parseBagInfo(node));
        profile.getManifestTypesRequired().addAll(BagitProfileDeserializer.parseManifestTypesRequired(node));
        profile.setFetchFileAllowed(node.get("Allow-Fetch.txt").asBoolean());
        logger.debug(messages.getString("fetch_allowed"), (Object)profile.isFetchFileAllowed());
        profile.setSerialization(Serialization.valueOf(node.get("Serialization").asText()));
        logger.debug(messages.getString("serialization_allowed"), (Object)profile.getSerialization());
        profile.getAcceptableMIMESerializationTypes().addAll(BagitProfileDeserializer.parseAcceptableSerializationFormats(node));
        profile.getTagManifestTypesRequired().addAll(BagitProfileDeserializer.parseRequiredTagmanifestTypes(node));
        profile.getTagFilesRequired().addAll(BagitProfileDeserializer.parseRequiredTagFiles(node));
        profile.getAcceptableBagitVersions().addAll(BagitProfileDeserializer.parseAcceptableVersions(node));
        return profile;
    }

    private static void parseBagitProfileInfo(JsonNode node, BagitProfile profile) {
        logger.debug(messages.getString("parsing_bagit_profile_info_section"));
        JsonNode bagitProfileInfoNode = node.get("BagIt-Profile-Info");
        BagitProfileDeserializer.parseMandatoryTagsOfBagitProfileInfo(bagitProfileInfoNode, profile);
        BagitProfileDeserializer.parseOptionalTagsOfBagitProfileInfo(bagitProfileInfoNode, profile);
    }

    private static void parseMandatoryTagsOfBagitProfileInfo(JsonNode bagitProfileInfoNode, BagitProfile profile) {
        logger.debug(messages.getString("parsing_mandatory_tags_of_bagit_profile_info_section"));
        String profileIdentifier = bagitProfileInfoNode.get("BagIt-Profile-Identifier").asText();
        logger.debug(messages.getString("identifier"), (Object)profileIdentifier);
        profile.setBagitProfileIdentifier(profileIdentifier);
        String sourceOrg = bagitProfileInfoNode.get("Source-Organization").asText();
        logger.debug(messages.getString("source_organization"), (Object)sourceOrg);
        profile.setSourceOrganization(sourceOrg);
        String extDescript = bagitProfileInfoNode.get("External-Description").asText();
        logger.debug(messages.getString("external_description"), (Object)extDescript);
        profile.setExternalDescription(extDescript);
        String version = bagitProfileInfoNode.get("Version").asText();
        logger.debug(messages.getString("version"), (Object)version);
        profile.setVersion(version);
    }

    private static void parseOptionalTagsOfBagitProfileInfo(JsonNode bagitProfileInfoNode, BagitProfile profile) {
        JsonNode contactPhoneNode;
        JsonNode contactEmailNode;
        logger.debug(messages.getString("parsing_optional_tags_of_bagit_profile_info_section"));
        JsonNode contactNameNode = bagitProfileInfoNode.get("Contact-Name");
        if (contactNameNode != null) {
            String contactName = contactNameNode.asText();
            logger.debug(messages.getString("contact_name"), (Object)contactName);
            profile.setContactName(contactName);
        }
        if ((contactEmailNode = bagitProfileInfoNode.get("Contact-Email")) != null) {
            String contactEmail = contactEmailNode.asText();
            logger.debug(messages.getString("contact_email"), (Object)contactEmail);
            profile.setContactEmail(contactEmail);
        }
        if ((contactPhoneNode = bagitProfileInfoNode.get("Contact-Phone")) != null) {
            String contactPhone = contactPhoneNode.asText();
            logger.debug(messages.getString("contact_phone"), (Object)contactPhone);
            profile.setContactPhone(contactPhone);
        }
    }

    private static Map<String, BagInfoRequirement> parseBagInfo(JsonNode rootNode) {
        JsonNode bagInfoNode = rootNode.get("Bag-Info");
        logger.debug(messages.getString("parsing_bag_info"));
        HashMap<String, BagInfoRequirement> bagInfo = new HashMap<String, BagInfoRequirement>();
        Iterator nodes = bagInfoNode.fields();
        while (nodes.hasNext()) {
            JsonNode repeatableNode;
            JsonNode valuesNode;
            Map.Entry node = (Map.Entry)nodes.next();
            BagInfoRequirement entry = new BagInfoRequirement();
            JsonNode requiredNode = ((JsonNode)node.getValue()).get("required");
            if (requiredNode != null) {
                entry.setRequired(requiredNode.asBoolean());
            }
            if ((valuesNode = ((JsonNode)node.getValue()).get("values")) != null) {
                for (JsonNode value : valuesNode) {
                    entry.getAcceptableValues().add(value.asText());
                }
            }
            if ((repeatableNode = ((JsonNode)node.getValue()).get("repeatable")) != null) {
                entry.setRepeatable(repeatableNode.asBoolean());
            }
            logger.debug("{}: {}", node.getKey(), (Object)entry);
            bagInfo.put((String)node.getKey(), entry);
        }
        return bagInfo;
    }

    private static List<String> parseManifestTypesRequired(JsonNode node) {
        JsonNode manifests = node.get("Manifests-Required");
        ArrayList<String> manifestTypes = new ArrayList<String>();
        for (JsonNode manifestName : manifests) {
            manifestTypes.add(manifestName.asText());
        }
        logger.debug(messages.getString("required_manifest_types"), manifestTypes);
        return manifestTypes;
    }

    private static List<String> parseAcceptableSerializationFormats(JsonNode node) {
        JsonNode serialiationFormats = node.get("Accept-Serialization");
        ArrayList<String> serialTypes = new ArrayList<String>();
        for (JsonNode serialiationFormat : serialiationFormats) {
            serialTypes.add(serialiationFormat.asText());
        }
        logger.debug(messages.getString("acceptable_serialization_mime_types"), serialTypes);
        return serialTypes;
    }

    private static List<String> parseRequiredTagmanifestTypes(JsonNode node) {
        JsonNode tagManifestsRequiredNodes = node.get("Tag-Manifests-Required");
        ArrayList<String> requiredTagmanifestTypes = new ArrayList<String>();
        if (tagManifestsRequiredNodes != null) {
            for (JsonNode tagManifestsRequiredNode : tagManifestsRequiredNodes) {
                requiredTagmanifestTypes.add(tagManifestsRequiredNode.asText());
            }
        }
        logger.debug(messages.getString("required_tagmanifest_types"), requiredTagmanifestTypes);
        return requiredTagmanifestTypes;
    }

    private static List<String> parseRequiredTagFiles(JsonNode node) {
        JsonNode tagFilesRequiredNodes = node.get("Tag-Files-Required");
        ArrayList<String> requiredTagFiles = new ArrayList<String>();
        if (tagFilesRequiredNodes != null) {
            for (JsonNode tagFilesRequiredNode : tagFilesRequiredNodes) {
                requiredTagFiles.add(tagFilesRequiredNode.asText());
            }
        }
        logger.debug(messages.getString("tag_files_required"), requiredTagFiles);
        return requiredTagFiles;
    }

    private static List<String> parseAcceptableVersions(JsonNode node) {
        JsonNode acceptableVersionsNodes = node.get("Accept-BagIt-Version");
        ArrayList<String> acceptableVersions = new ArrayList<String>();
        for (JsonNode acceptableVersionsNode : acceptableVersionsNodes) {
            acceptableVersions.add(acceptableVersionsNode.asText());
        }
        logger.debug(messages.getString("acceptable_bagit_versions"), acceptableVersions);
        return acceptableVersions;
    }
}

