/*
 * Decompiled with CFR 0.152.
 */
package nl.komponents.kovenant;

import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import nl.komponents.kovenant.WorkQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0011\u0013)\u0011\u0001B\u0001\u0006\u0003!-Q!\u0001C\u0004\tMa\u0001!\u0006\u0003\u0005\u0001!\u0005Q#\u0001\r\u00023\u0011I!!C\u0001%\u0002a\r\u0011UA)\u0004\u0003!\u0011Qu\u0002\u0003\u0002\u0011\u0013i!\u0001$\u0001\u001d\u0001E\u001b\u0011\u0001C\u0003&\u0018\u0011\t\u0001\u0012B\u0007\u0003\u0019\u0003a\u0002!G\u0002\t\f5\t\u0001DB)\u0004\u0003!5QU\u0003\u0003\f\u0011\u001di\u0011\u0001g\u0004\u001a\u0007!AQ\"\u0001\u000f\u0001#\u000e\t\u0001\u0012CS\u0010\t-A\u0011\"\u0004\u0002\r\u0002q\u0001\u0011d\u0001E\n\u001b\u0005Az!G\u0002\t\f5\t\u0001DB)\u0004\u0003!QQU\u0003\u0003\u0014\u0011+i\u0011\u0001g\u0004\u001a\u0007!AQ\"\u0001\u000f\u0001#\u000e\t\u0001\u0012CS\b\tMA1\"\u0004\u0002\r\u0002q\u0001\u0011kA\u0001\t\u000b%:A!\u0011\u0005\t\u00065\t\u0001dA)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\u001dQ\"\u0001\r\u0005#\u000e\tQ\u0001\u0001"}, strings={"Lnl/komponents/kovenant/BlockingSupportWorkQueue;", "V", "", "Lnl/komponents/kovenant/WorkQueue;", "()V", "mutex", "Ljava/lang/Object;", "waitingThreads", "Ljava/util/concurrent/atomic/AtomicInteger;", "blockingPoll", "()Ljava/lang/Object;", "timeoutMs", "", "(J)Ljava/lang/Object;", "offer", "", "elem", "(Ljava/lang/Object;)Z", "poll", "block", "(ZJ)Ljava/lang/Object;", "tryOffer", "tryPoll"}, moduleName="kovenant-core-compileKotlin")
public abstract class BlockingSupportWorkQueue<V>
implements WorkQueue<V> {
    private final AtomicInteger waitingThreads = new AtomicInteger(0);
    private final Object mutex = new Object();

    @Nullable
    public abstract V tryPoll();

    public abstract boolean tryOffer(@NotNull V var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(@NotNull V elem) {
        Intrinsics.checkParameterIsNotNull(elem, (String)"elem");
        boolean added = this.tryOffer(elem);
        if (added && this.waitingThreads.get() > 0) {
            Object lock$iv = this.mutex;
            synchronized (lock$iv) {
                this.mutex.notifyAll();
                Unit unit = Unit.INSTANCE;
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public V poll(boolean block, long timeoutMs) {
        if (!block) {
            return this.tryPoll();
        }
        V elem = this.tryPoll();
        if (elem != null) {
            return elem;
        }
        this.waitingThreads.incrementAndGet();
        try {
            V v = timeoutMs > -1L ? this.blockingPoll(timeoutMs) : this.blockingPoll();
            return v;
        }
        finally {
            this.waitingThreads.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V blockingPoll() {
        Object lock$iv = this.mutex;
        synchronized (lock$iv) {
            V v;
            while (true) {
                V retry;
                if ((retry = this.tryPoll()) == null) break block5;
                v = retry;
                break;
            }
            {
                block5: {
                    return v;
                }
                this.mutex.wait();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final V blockingPoll(long timeoutMs) {
        void lock$iv;
        long deadline = System.currentTimeMillis() + timeoutMs;
        Object object = this.mutex;
        synchronized (lock$iv) {
            V v;
            while (true) {
                V retry;
                if ((retry = this.tryPoll()) == null && System.currentTimeMillis() < deadline) break block5;
                v = retry;
                break;
            }
            {
                block5: {
                    return v;
                }
                this.mutex.wait(timeoutMs);
                continue;
            }
        }
    }

    @Override
    public boolean isNotEmpty() {
        return WorkQueue.DefaultImpls.isNotEmpty(this);
    }

    @Override
    public boolean isEmpty() {
        return WorkQueue.DefaultImpls.isEmpty(this);
    }
}

